/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.doma.internal.jdbc.command.GetValueFunction;
import org.seasar.doma.internal.jdbc.command.ResultFetcher;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.MappedPropertyNotFoundException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.wrapper.Wrapper;

public class EntityFetcher<E>
implements ResultFetcher<ResultSet, E> {
    protected final Query query;
    protected final EntityType<E> entityType;
    protected Map<Integer, String> indexMap;

    public EntityFetcher(Query query, EntityType<E> entityType) {
        AssertionUtil.assertNotNull((Object)query, entityType);
        this.query = query;
        this.entityType = entityType;
    }

    @Override
    public void fetch(ResultSet resultSet, E entity) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, entity);
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap(resultSet.getMetaData(), this.entityType);
        }
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        for (Map.Entry<Integer, String> entry : this.indexMap.entrySet()) {
            Integer index = entry.getKey();
            String propertyName = entry.getValue();
            GetValueFunction function = new GetValueFunction(resultSet, index);
            EntityPropertyType<E, ?> propertyType = this.entityType.getEntityPropertyType(propertyName);
            Wrapper<?> wrapper = propertyType.getWrapper(entity);
            wrapper.accept(jdbcMappingVisitor, function);
        }
        this.entityType.saveCurrentStates(entity);
    }

    protected HashMap<Integer, String> createIndexMap(ResultSetMetaData resultSetMeta, EntityType<E> entityType) throws SQLException {
        HashMap<Integer, String> indexMap = new HashMap<Integer, String>();
        HashMap<String, String> columnNameMap = this.createColumnNameMap(entityType);
        int count = resultSetMeta.getColumnCount();
        for (int i = 1; i < count + 1; ++i) {
            String columnName = resultSetMeta.getColumnLabel(i);
            String lowerCaseColumnName = columnName.toLowerCase();
            String propertyName = columnNameMap.get(lowerCaseColumnName);
            if (propertyName == null) {
                if ("doma_rownumber_".equals(lowerCaseColumnName)) continue;
                Sql<?> sql = this.query.getSql();
                NamingType namingType = entityType.getNamingType();
                throw new MappedPropertyNotFoundException(columnName, namingType.revert(columnName), entityType.getEntityClass().getName(), sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath());
            }
            indexMap.put(i, propertyName);
        }
        return indexMap;
    }

    protected HashMap<String, String> createColumnNameMap(EntityType<E> entityType) {
        List<EntityPropertyType<E, ?>> propertyTypes = entityType.getEntityPropertyTypes();
        HashMap<String, String> result = new HashMap<String, String>(propertyTypes.size());
        for (EntityPropertyType<E, ?> p : propertyTypes) {
            String columnName = p.getColumnName();
            result.put(columnName.toLowerCase(), p.getName());
        }
        return result;
    }
}

