/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import org.seasar.doma.internal.jdbc.dialect.StandardPagingTransformer;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.OrderByClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.jdbc.SqlNode;

public class HsqldbPagingTransformer
extends StandardPagingTransformer {
    public HsqldbPagingTransformer(long offset, long limit) {
        super(offset, limit);
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        ForUpdateClauseNode forUpdate;
        if (this.processed) {
            return node;
        }
        this.processed = true;
        OrderByClauseNode originalOrderBy = node.getOrderByClauseNode();
        OrderByClauseNode orderBy = node.getOrderByClauseNode();
        if (originalOrderBy != null) {
            orderBy = new OrderByClauseNode(originalOrderBy.getWordNode());
            for (SqlNode child : originalOrderBy.getChildren()) {
                orderBy.addNode(child);
            }
        } else {
            orderBy = new OrderByClauseNode("");
        }
        orderBy.addNode(new FragmentNode(" limit "));
        if (this.limit >= 0L) {
            orderBy.addNode(new FragmentNode(String.valueOf(this.limit)));
        } else {
            orderBy.addNode(new FragmentNode("0"));
        }
        if (this.offset >= 0L) {
            orderBy.addNode(new FragmentNode(" offset "));
            orderBy.addNode(new FragmentNode(String.valueOf(this.offset)));
        }
        if ((forUpdate = node.getForUpdateClauseNode()) != null) {
            orderBy.addNode(new FragmentNode(" "));
        }
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(node.getSelectClauseNode());
        result.setFromClauseNode(node.getFromClauseNode());
        result.setWhereClauseNode(node.getWhereClauseNode());
        result.setGroupByClauseNode(node.getGroupByClauseNode());
        result.setHavingClauseNode(node.getHavingClauseNode());
        result.setOrderByClauseNode(orderBy);
        result.setForUpdateClauseNode(forUpdate);
        return result;
    }
}

