/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.query.ModifyQuery;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;

public abstract class SqlFileModifyQuery
implements ModifyQuery {
    protected final SqlKind kind;
    protected Config config;
    protected String sqlFilePath;
    protected final Map<String, Value> parameters = new LinkedHashMap<String, Value>();
    protected String callerClassName;
    protected String callerMethodName;
    protected PreparedSql sql;
    protected int queryTimeout;
    protected boolean optimisticLockCheckRequired;

    protected SqlFileModifyQuery(SqlKind kind) {
        AssertionUtil.assertNotNull((Object)kind);
        this.kind = kind;
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected void prepareSql() {
        SqlFile sqlFile = this.config.getSqlFileRepository().getSqlFile(this.sqlFilePath, this.config.getDialect());
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, sqlFile.getPath(), evaluator);
        this.sql = sqlBuilder.build(sqlFile.getSqlNode());
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.parameters.put(name, new Value(type, value));
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return null;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    public abstract <E> void setEntityAndEntityType(E var1, EntityType<E> var2);

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

