/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.SqlFileModifyQuery;
import org.seasar.doma.internal.jdbc.query.UpdateQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileUpdateQuery
extends SqlFileModifyQuery
implements UpdateQuery {
    protected EntityHandler<?> entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileUpdateQuery() {
        super(SqlKind.UPDATE);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.sqlFilePath, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.preUpdate();
        this.prepareOptimisticLock();
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersion() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersion();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postUpdate();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(entity, entityType);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFilePostUpdateContext
    extends AbstractPostUpdateContext {
        public SqlFilePostUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFilePreUpdateContext
    extends AbstractPreUpdateContext {
        public SqlFilePreUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler<E> {
        protected E entity;
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entity, entityType);
            this.entity = entity;
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preUpdate() {
            SqlFilePreUpdateContext context = new SqlFilePreUpdateContext(this.entityType);
            this.entityType.preUpdate(this.entity, context);
        }

        protected void postUpdate() {
            SqlFilePostUpdateContext context = new SqlFilePostUpdateContext(this.entityType);
            this.entityType.postUpdate(this.entity, context);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored && !SqlFileUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersion() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored) {
                this.versionPropertyType.increment(this.entity);
            }
        }
    }
}

