/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.tx.KeepAliveLocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.LocalTransactionNotYetBegunException;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;
import org.seasar.doma.message.Message;

public final class LocalTransactionalDataSource
implements DataSource {
    private final ThreadLocal<LocalTransactionContext> localTxContextHolder = new ThreadLocal();
    private final DataSource dataSource;

    public LocalTransactionalDataSource(DataSource dataSource) {
        AssertionUtil.assertNotNull(dataSource);
        this.dataSource = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionInternal();
    }

    private Connection getConnectionInternal() {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (context == null) {
            throw new LocalTransactionNotYetBegunException(Message.DOMA2048, new Object[0]);
        }
        return context.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }
}

