/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.slim3.gen;

/**
 * The collection of constants of class.
 * 
 * @author taedium
 * @since 1.0.0
 * 
 */
public final class ClassConstants {

    /** {@code char} */
    public static final String primitive_char = "char";

    /** {@code byte} */
    public static final String primitive_byte = "byte";

    /** {@code boolean} */
    public static final String primitive_boolean = "boolean";

    /** {@code short} */
    public static final String primitive_short = "short";

    /** {@code int} */
    public static final String primitive_int = "int";

    /** {@code long} */
    public static final String primitive_long = "long";

    /** {@code float} */
    public static final String primitive_float = "float";

    /** {@code double} */
    public static final String primitive_double = "double";

    /** {@code byte} array */
    public static final String primitive_byte_array = "byte[]";

    /** {@code org.slim3.datastore.ModelMeta} */
    public static final String ModelMeta = "org.slim3.datastore.ModelMeta";

    /** {@code org.slim3.datastore.ModelRef} */
    public static final String ModelRef = "org.slim3.datastore.ModelRef";

    /** {@code org.slim3.datastore.InverseModelRef} */
    public static final String InverseModelRef =
        "org.slim3.datastore.InverseModelRef";

    /** {@code org.slim3.datastore.InverseModelListRef} */
    public static final String InverseModelListRef =
        "org.slim3.datastore.InverseModelListRef";

    /** {@code org.slim3.datastore.CoreAttributeMeta} */
    public static final String CoreAttributeMeta =
        "org.slim3.datastore.CoreAttributeMeta";

    /** {@code org.slim3.datastore.ModelRefAttributeMeta} */
    public static final String ModelRefAttributeMeta =
        "org.slim3.datastore.ModelRefAttributeMeta";

    /** {@code org.slim3.datastore.StringAttributeMeta} */
    public static final String StringAttributeMeta =
        "org.slim3.datastore.StringAttributeMeta";

    /** {@code org.slim3.datastore.UnindexedAttributeMeta} */
    public static final String UnindexedAttributeMeta =
        "org.slim3.datastore.UnindexedAttributeMeta";

    /** {@code org.slim3.datastore.CollectionAttributeMeta} */
    public static final String CollectionAttributeMeta =
        "org.slim3.datastore.CollectionAttributeMeta";

    /** {@code org.slim3.datastore.StringCollectionAttributeMeta} */
    public static final String StringCollectionAttributeMeta =
        "org.slim3.datastore.StringCollectionAttributeMeta";

    /** {@code org.slim3.controller.Controller} */
    public static final String Controller = "org.slim3.controller.Controller";

    /** {@code org.slim3.controller.Navigation} */
    public static final String Navigation = "org.slim3.controller.Navigation";

    /** {@code junit.framework.TestCase} */
    public static final String TestCase = "junit.framework.TestCase";

    /** {@code org.slim3.tester.ControllerTestCase} */
    public static final String ControllerTestCase =
        "org.slim3.tester.ControllerTestCase";

    /** {@code org.slim3.tester.ServletTestCase} */
    public static final String ServletTestCase =
        "org.slim3.tester.ServletTestCase";

    /** {@code org.slim3.tester.AppEngineTestCase} */
    public static final String AppEngineTestCase =
        "org.slim3.tester.AppEngineTestCase";

    /** {@code com.google.gwt.user.client.rpc.AsyncCallback} */
    public static final String AsyncCallback =
        "com.google.gwt.user.client.rpc.AsyncCallback";

    /** {@code com.google.appengine.api.datastore.Entity} */
    public static final String Entity =
        "com.google.appengine.api.datastore.Entity";

    /** {@code java.lang.Object} */
    public static final String Object = "java.lang.Object";

    /** {@code java.lang.String} */
    public static final String String = "java.lang.String";

    /** {@code java.lang.Character} */
    public static final String Character = "java.lang.Character";

    /** {@code java.lang.Boolean} */
    public static final String Boolean = "java.lang.Boolean";

    /** {@code java.lang.Byte} */
    public static final String Byte = "java.lang.Byte";

    /** {@code java.lang.Short} */
    public static final String Short = "java.lang.Short";

    /** {@code java.lang.Integer} */
    public static final String Integer = "java.lang.Integer";

    /** {@code java.lang.Long} */
    public static final String Long = "java.lang.Long";

    /** {@code java.lang.Float} */
    public static final String Float = "java.lang.Float";

    /** {@code java.lang.Double} */
    public static final String Double = "java.lang.Double";

    /** {@code java.lang.Double} */
    public static final String Date = "java.util.Date";

    /** {@code com.google.appengine.api.users.User} */
    public static final String User = "com.google.appengine.api.users.User";

    /** {@code com.google.appengine.api.datastore.Key} */
    public static final String Key = "com.google.appengine.api.datastore.Key";

    /** {@code com.google.appengine.api.datastore.Category} */
    public static final String Category =
        "com.google.appengine.api.datastore.Category";

    /** {@code com.google.appengine.api.datastore.Email} */
    public static final String Email =
        "com.google.appengine.api.datastore.Email";
    /** {@code com.google.appengine.api.datastore.GeoPt} */
    public static final String GeoPt =
        "com.google.appengine.api.datastore.GeoPt";

    /** {@code com.google.appengine.api.datastore.IMHandle} */
    public static final String IMHandle =
        "com.google.appengine.api.datastore.IMHandle";

    /** {@code com.google.appengine.api.datastore.Link} */
    public static final String Link = "com.google.appengine.api.datastore.Link";

    /** {@code com.google.appengine.api.datastore.PhoneNumber} */
    public static final String PhoneNumber =
        "com.google.appengine.api.datastore.PhoneNumber";

    /** {@code com.google.appengine.api.datastore.PostalAddress} */
    public static final String PostalAddress =
        "com.google.appengine.api.datastore.PostalAddress";

    /** {@code com.google.appengine.api.datastore.Rating} */
    public static final String Rating =
        "com.google.appengine.api.datastore.Rating";

    /** {@code com.google.appengine.api.datastore.ShortBlob} */
    public static final String ShortBlob =
        "com.google.appengine.api.datastore.ShortBlob";

    /** {@code com.google.appengine.api.datastore.Blob} */
    public static final String Blob = "com.google.appengine.api.datastore.Blob";

    /** {@code com.google.appengine.api.datastore.Text} */
    public static final String Text = "com.google.appengine.api.datastore.Text";

    /** {@code java.util.Collection} */
    public static final String Collection = "java.util.Collection";

    /** {@code java.util.List} */
    public static final String List = "java.util.List";

    /** {@code java.util.Set} */
    public static final String Set = "java.util.Set";

    /** {@code java.util.SortedSet} */
    public static final String SortedSet = "java.util.SortedSet";

    /** {@code java.util.ArrayList} */
    public static final String ArrayList = "java.util.ArrayList";

    /** {@code java.util.LinkedList} */
    public static final String LinkedList = "java.util.LinkedList";

    /** {@code java.util.Vector} */
    public static final String Vector = "java.util.Vector";

    /** {@code java.util.Stack} */
    public static final String Stack = "java.util.Stack";

    /** {@code java.util.HashSet} */
    public static final String HashSet = "java.util.HashSet";

    /** {@code java.util.LinkedHashSet} */
    public static final String LinkedHashSet = "java.util.LinkedHashSet";

    /** {@code java.util.TreeSet} */
    public static final String TreeSet = "java.util.TreeSet";

    /** {@code org.junit.Assert} */
    public static final String Assert = "org.junit.Assert";

    /** {@code org.hamcrest.CoreMatchers} */
    public static final String CoreMatchers = "org.hamcrest.CoreMatchers";

}
