/**
 * FreeTTSgpTv
 * 
 * }CR~W[i
 * yRzJava APIAgĂ܂? (20) F/̂߂API - Java Speech APIJSR 113
 * http://journal.mycom.co.jp/column/jsr/020/index.html
 * Xg1 SpeechSample.java
 * 
 * yz
 * PDjsapi.jarɃNXpXʂ
 * QDVZUCULɂ邽߂̃vpeBt@Cispeech.propertiesĵꂩ̏ꏊɔzuB
 * @@EC:\Documents and Settings\\usernameȂǎ̃[UtH_
 * @@EJRElibtH_
 * @@speech.propertieśAFreeTTS̃A[JCuɑ݂
 */
package sample.speech;

import java.beans.PropertyVetoException;
import java.util.Locale;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class SpeechSample {
	private Synthesizer synthesizer = null;

	public SpeechSample() {
		// VZUCŨ[hw
		SynthesizerModeDesc desc = new SynthesizerModeDesc(null, "general",
				Locale.US, Boolean.FALSE, null);
		
		try {
			// VZUCU쐬
			synthesizer = Central.createSynthesizer(desc);
			if (synthesizer == null) {
				System.err.println("ERROR! VZUCU܂B");
				System.exit(1);
			}

			// {CX쐬
			String voiceName = "kevin16";
			Voice voice = new Voice(voiceName, Voice.GENDER_DONT_CARE,
					Voice.AGE_DONT_CARE, null);
			if (voice == null) {
				System.err.println("ERROR! VZUCU{CX " + voiceName
						+ " T|[gĂ܂B");
				System.exit(1);
			}

			// \[X̊蓖
			synthesizer.allocate();
			synthesizer.resume();
			// {CX̐ݒ
			synthesizer.getSynthesizerProperties().setVoice(voice);
		} catch (EngineException ex) {
			ex.printStackTrace();
		} catch (PropertyVetoException ex) {
			ex.printStackTrace();
		} catch (AudioException ex) {
			ex.printStackTrace();
		}
	}

	public void speak(String message) {
		try {
			// eLXg̓ǂݏグ
			synthesizer.speakPlainText(message, null);
			synthesizer.waitEngineState(Synthesizer.QUEUE_EMPTY);
		} catch (InterruptedException ex) {
			ex.printStackTrace();
		}
	}

	public void deallocateSynthesizer() {
		try {
			// \[X̊J
			synthesizer.deallocate();
		} catch (EngineException ex) {
			ex.printStackTrace();
		}
	}

	public static void main(String[] args) {
		String message = (args.length > 0) ? args[0] : "Hello World.";

		SpeechSample sample = new SpeechSample();
		sample.speak(message);
		sample.deallocateSynthesizer();
	}
}
