/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jdo;

import java.util.Collection;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.appengine.BatchDeleteManager;
import org.datanucleus.store.appengine.BatchManager;
import org.datanucleus.store.appengine.BatchPutManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.jdo.DatastoreJDOTransaction;

public class DatastoreJDOPersistenceManager
extends JDOPersistenceManager {
    public DatastoreJDOPersistenceManager(JDOPersistenceManagerFactory apmf, String userName, String password) {
        super(apmf, userName, password);
        this.setTransaction(this.objectMgr.getTransaction());
    }

    public Object getObjectById(Class cls, Object key) {
        try {
            key = EntityUtils.idToInternalKey(this.getObjectManager(), cls, key, false);
        }
        catch (NucleusUserException e) {
            String keyStr = key == null ? "" : key.toString();
            String msg = "Exception converting " + keyStr + " to an internal key.";
            if (e.isFatal()) {
                throw new JDOFatalUserException(msg, (Throwable)e);
            }
            throw new JDOUserException(msg, (Throwable)e);
        }
        return super.getObjectById(cls, key);
    }

    private BatchPutManager getBatchPutManager() {
        DatastoreManager dm = (DatastoreManager)this.getObjectManager().getStoreManager();
        return dm.getBatchPutManager();
    }

    private BatchDeleteManager getBatchDeleteManager() {
        DatastoreManager dm = (DatastoreManager)this.getObjectManager().getStoreManager();
        return dm.getBatchDeleteManager();
    }

    public Collection makePersistentAll(final Collection pcs) {
        return (Collection)new BatchManagerWrapper().call(this.getBatchPutManager(), new Callable<Collection>(){

            @Override
            public Collection call() {
                return DatastoreJDOPersistenceManager.super.makePersistentAll(pcs);
            }
        });
    }

    public void deletePersistentAll(final Collection pcs) {
        new BatchManagerWrapper().call(this.getBatchDeleteManager(), new Callable<Void>(){

            @Override
            public Void call() {
                DatastoreJDOPersistenceManager.super.deletePersistentAll(pcs);
                return null;
            }
        });
    }

    protected void setTransaction(Transaction tx) {
        DatastoreManager storeMgr = (DatastoreManager)this.getObjectManager().getStoreManager();
        if (storeMgr.connectionFactoryIsTransactional()) {
            this.jdotx = new DatastoreJDOTransaction((PersistenceManager)this, tx);
        } else {
            super.setTransaction(tx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Callable<T> {
        public T call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BatchManagerWrapper {
        private BatchManagerWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T call(BatchManager batchMgr, Callable<T> callable) {
            batchMgr.start();
            try {
                T t = callable.call();
                return t;
            }
            finally {
                batchMgr.finish((DatastorePersistenceHandler)DatastoreJDOPersistenceManager.this.getObjectManager().getStoreManager().getPersistenceHandler());
            }
        }
    }
}

