/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.meta.DomainMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.DomainMirror;
import org.seasar.doma.internal.apt.mirror.EnumDomainMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DomainMetaFactory
implements TypeElementMetaFactory<DomainMeta> {
    private final ProcessingEnvironment env;

    public DomainMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    @Override
    public DomainMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        DomainMirror domainMirror = DomainMirror.newInstance(classElement, this.env);
        if (domainMirror == null) {
            throw new AptIllegalStateException("domainMirror");
        }
        DomainMeta domainMeta = new DomainMeta(classElement, classElement.asType());
        domainMeta.setDomainMirror(domainMirror);
        this.doWrapperType(classElement, domainMeta);
        this.validateClass(classElement, domainMeta);
        if (domainMeta.providesConstructor()) {
            this.validateConstructor(classElement, domainMeta);
        } else {
            this.validateFactoryMethod(classElement, domainMeta);
        }
        this.validateAccessorMethod(classElement, domainMeta);
        return domainMeta;
    }

    protected void doWrapperType(TypeElement classElement, DomainMeta domainMeta) {
        EnumDomainMirror enumDomainMirror;
        BasicType basicType = BasicType.newInstance(domainMeta.getValueType(), this.env);
        if (basicType == null) {
            DomainMirror domainMirror = domainMeta.getDomainMirror();
            throw new AptException((MessageResource)Message.DOMA4102, this.env, (Element)classElement, domainMirror.getAnnotationMirror(), domainMirror.getValueType(), domainMirror.getValueTypeValue());
        }
        if (basicType.isEnum() && (enumDomainMirror = EnumDomainMirror.newInstance(classElement, this.env)) != null) {
            throw new AptException((MessageResource)Message.DOMA4178, this.env, (Element)classElement, enumDomainMirror.getAnnotationMirror(), enumDomainMirror.getValueType(), enumDomainMirror.getValueTypeValue());
        }
        domainMeta.setWrapperType(basicType.getWrapperType());
    }

    protected void validateClass(TypeElement classElement, DomainMeta domainMeta) {
        if (classElement.getKind() == ElementKind.CLASS) {
            if (domainMeta.providesConstructor() && classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new AptException((MessageResource)Message.DOMA4132, this.env, (Element)classElement, new Object[0]);
            }
            if (!classElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4107, this.env, (Element)classElement, new Object[0]);
            }
            if (classElement.getNestingKind().isNested()) {
                throw new AptException((MessageResource)Message.DOMA4179, this.env, (Element)classElement, new Object[0]);
            }
        } else if (classElement.getKind() == ElementKind.ENUM) {
            if (domainMeta.providesConstructor()) {
                DomainMirror domainMirror = domainMeta.getDomainMirror();
                throw new AptException((MessageResource)Message.DOMA4184, this.env, (Element)classElement, domainMirror.getAnnotationMirror(), domainMirror.getFactoryMethod(), new Object[0]);
            }
            if (classElement.getNestingKind().isNested()) {
                throw new AptException((MessageResource)Message.DOMA4179, this.env, (Element)classElement, new Object[0]);
            }
        } else {
            DomainMirror domainMirror = domainMeta.getDomainMirror();
            throw new AptException((MessageResource)Message.DOMA4105, this.env, (Element)classElement, domainMirror.getAnnotationMirror(), new Object[0]);
        }
    }

    protected void validateConstructor(TypeElement classElement, DomainMeta domainMeta) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
            List<? extends VariableElement> parameters;
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || (parameters = constructor.getParameters()).size() != 1) continue;
            TypeMirror parameterType = this.env.getTypeUtils().erasure(parameters.get(0).asType());
            if (!this.env.getTypeUtils().isSameType(parameterType, domainMeta.getValueType())) continue;
            return;
        }
        throw new AptException((MessageResource)Message.DOMA4103, this.env, (Element)classElement, domainMeta.getValueType());
    }

    protected void validateFactoryMethod(TypeElement classElement, DomainMeta domainMeta) {
        for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(domainMeta.getFactoryMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getParameters().size() != 1) continue;
            TypeMirror parameterType = method.getParameters().get(0).asType();
            if (!this.env.getTypeUtils().isAssignable(domainMeta.getValueType(), parameterType)) continue;
            TypeMirror returnType = this.env.getTypeUtils().erasure(method.getReturnType());
            if (!this.env.getTypeUtils().isAssignable(returnType, domainMeta.getType())) continue;
            return;
        }
        throw new AptException((MessageResource)Message.DOMA4106, this.env, (Element)classElement, domainMeta.getFactoryMethod(), classElement.asType(), domainMeta.getValueType(), domainMeta.getFactoryMethod());
    }

    protected void validateAccessorMethod(TypeElement classElement, DomainMeta domainMeta) {
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            for (ExecutableElement method : ElementFilter.methodsIn(t.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals(domainMeta.getAccessorMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty()) continue;
                TypeMirror returnType = this.env.getTypeUtils().erasure(method.getReturnType());
                if (!this.env.getTypeUtils().isAssignable(returnType, domainMeta.getValueType())) continue;
                return;
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
        throw new AptException((MessageResource)Message.DOMA4104, this.env, (Element)classElement, domainMeta.getAccessorMethod(), domainMeta.getValueType());
    }
}

