/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.mirror.EntityMirror;
import org.seasar.doma.internal.apt.mirror.TableMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;

public class EntityMeta
implements TypeElementMeta {
    protected final List<EntityPropertyMeta> allPropertyMetas = new ArrayList<EntityPropertyMeta>();
    protected final List<EntityPropertyMeta> idPropertyMetas = new ArrayList<EntityPropertyMeta>();
    protected final EntityMirror entityMirror;
    protected final NamingType namingType;
    protected final TypeElement entityElement;
    protected TableMirror tableMirror;
    protected EntityPropertyMeta versionPropertyMeta;
    protected EntityPropertyMeta generatedIdPropertyMeta;
    protected String entityName;
    protected String entityTypeName;
    protected OriginalStatesMeta originalStatesMeta;
    protected boolean error;

    public EntityMeta(EntityMirror entityMirror, TypeElement entityElement) {
        AssertionUtil.assertNotNull(entityMirror);
        this.entityMirror = entityMirror;
        this.namingType = entityMirror.getNamingValue();
        this.entityElement = entityElement;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    EntityMirror getEntityMirror() {
        return this.entityMirror;
    }

    public NamingType getNamingType() {
        return this.namingType;
    }

    public TypeElement getEntityElement() {
        return this.entityElement;
    }

    public void setTableMirror(TableMirror tableMirror) {
        this.tableMirror = tableMirror;
    }

    public void addPropertyMeta(EntityPropertyMeta propertyMeta) {
        AssertionUtil.assertNotNull(propertyMeta);
        this.allPropertyMetas.add(propertyMeta);
        if (propertyMeta.isId()) {
            this.idPropertyMetas.add(propertyMeta);
            if (propertyMeta.getIdGeneratorMeta() != null) {
                this.generatedIdPropertyMeta = propertyMeta;
            }
        }
        if (propertyMeta.isVersion()) {
            this.versionPropertyMeta = propertyMeta;
        }
    }

    public List<EntityPropertyMeta> getAllPropertyMetas() {
        return this.allPropertyMetas;
    }

    public List<EntityPropertyMeta> getIdPropertyMetas() {
        return this.idPropertyMetas;
    }

    public boolean hasVersionPropertyMeta() {
        return this.versionPropertyMeta != null;
    }

    public EntityPropertyMeta getVersionPropertyMeta() {
        return this.versionPropertyMeta;
    }

    public boolean hasGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta != null;
    }

    public EntityPropertyMeta getGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public void setEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
    }

    public boolean hasOriginalStatesMeta() {
        return this.originalStatesMeta != null;
    }

    public OriginalStatesMeta getOriginalStatesMeta() {
        return this.originalStatesMeta;
    }

    public void setOriginalStatesMeta(OriginalStatesMeta originalStatesMeta) {
        this.originalStatesMeta = originalStatesMeta;
    }

    public TypeMirror getEntityListener() {
        return this.entityMirror.getListenerValue();
    }

    public String getCatalogName() {
        return this.tableMirror != null ? this.tableMirror.getCatalogValue() : "";
    }

    public String getSchemaName() {
        return this.tableMirror != null ? this.tableMirror.getSchemaValue() : "";
    }

    public String getTableName() {
        String tableName = this.tableMirror != null ? this.tableMirror.getNameValue() : "";
        return !tableName.isEmpty() ? tableName : this.namingType.apply(this.entityName);
    }

    public boolean isAbstract() {
        return this.entityElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

