/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Entity;
import org.seasar.doma.EntityField;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMetaFactory;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.EntityMirror;
import org.seasar.doma.internal.apt.mirror.TableMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityListener;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityMetaFactory
implements TypeElementMetaFactory<EntityMeta> {
    protected final ProcessingEnvironment env;
    protected final EntityPropertyMetaFactory propertyMetaFactory;

    public EntityMetaFactory(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory) {
        AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
        this.env = env;
        this.propertyMetaFactory = propertyMetaFactory;
    }

    @Override
    public EntityMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        EntityMirror entityMirror = EntityMirror.newInstance(classElement, this.env);
        if (entityMirror == null) {
            throw new AptIllegalStateException("entityMirror.");
        }
        EntityMeta entityMeta = new EntityMeta(entityMirror, classElement);
        this.doClassElement(classElement, entityMeta);
        this.doFieldElements(classElement, entityMeta);
        this.validateGeneratedId(classElement, entityMeta);
        return entityMeta;
    }

    protected void doClassElement(TypeElement classElement, EntityMeta entityMeta) {
        this.validateClass(classElement, entityMeta);
        this.validateConstructor(classElement, entityMeta);
        this.validateEntityListener(classElement, entityMeta);
        String entityName = classElement.getSimpleName().toString();
        entityMeta.setEntityName(entityName);
        entityMeta.setEntityTypeName(TypeMirrorUtil.getTypeName(classElement.asType(), this.env));
        this.doTable(classElement, entityMeta);
    }

    protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
        if (classElement.getKind() != ElementKind.CLASS) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            throw new AptException((MessageResource)Message.DOMA4015, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), new Object[0]);
        }
        if (classElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4018, this.env, (Element)classElement, new Object[0]);
        }
        if (!classElement.getTypeParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4051, this.env, (Element)classElement, new Object[0]);
        }
    }

    protected void validateConstructor(TypeElement classElement, EntityMeta entityMeta) {
        if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(classElement, this.env);
        if (constructor == null || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new AptException((MessageResource)Message.DOMA4124, this.env, (Element)classElement, new Object[0]);
        }
    }

    protected void validateEntityListener(TypeElement classElement, EntityMeta entityMeta) {
        EntityMirror entityMirror = entityMeta.getEntityMirror();
        TypeMirror listenerType = entityMirror.getListenerValue();
        TypeMirror argumentType = this.getListenerArgumentType(listenerType);
        if (argumentType == null) {
            throw new AptIllegalStateException("argumentType");
        }
        if (!TypeMirrorUtil.isAssignable(classElement.asType(), argumentType, this.env)) {
            throw new AptException((MessageResource)Message.DOMA4038, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerType, argumentType, classElement.getQualifiedName());
        }
        TypeElement listenerElement = TypeMirrorUtil.toTypeElement(listenerType, this.env);
        if (listenerElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (listenerElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4166, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerElement.getQualifiedName());
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(listenerElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4167, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), listenerElement.getQualifiedName());
        }
    }

    protected TypeMirror getListenerArgumentType(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.env.getTypeUtils().directSupertypes(typeMirror)) {
            if (!TypeMirrorUtil.isAssignable(typeMirror2, EntityListener.class, this.env)) continue;
            if (TypeMirrorUtil.isSameType(typeMirror2, EntityListener.class, this.env)) {
                DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror2, this.env);
                AssertionUtil.assertNotNull(declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals(1, args.size());
                return args.get(0);
            }
            TypeMirror argumentType = this.getListenerArgumentType(typeMirror2);
            if (argumentType == null) continue;
            return argumentType;
        }
        return null;
    }

    protected void doTable(TypeElement classElement, EntityMeta entityMeta) {
        TableMirror tableMirror = TableMirror.newInstance(classElement, this.env);
        if (tableMirror == null) {
            return;
        }
        entityMeta.setTableMirror(tableMirror);
    }

    protected void doFieldElements(TypeElement classElement, EntityMeta entityMeta) {
        for (VariableElement fieldElement : this.getFieldElements(classElement)) {
            try {
                if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                    this.doOriginalStatesField(classElement, fieldElement, entityMeta);
                    continue;
                }
                this.doEntityPropertyMeta(fieldElement, entityMeta);
            }
            catch (AptException e) {
                Notifier.notify(this.env, e);
                entityMeta.setError(true);
            }
        }
    }

    protected List<VariableElement> getFieldElements(TypeElement classElement) {
        LinkedList<VariableElement> results = new LinkedList<VariableElement>();
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            if (t.getAnnotation(Entity.class) != null) {
                LinkedList<VariableElement> fields = new LinkedList<VariableElement>();
                for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                    fields.add(field);
                }
                Collections.reverse(fields);
                results.addAll(fields);
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
        Collections.reverse(results);
        LinkedList hiderFields = new LinkedList(results);
        Iterator it = results.iterator();
        while (it.hasNext()) {
            VariableElement hidden = (VariableElement)it.next();
            for (VariableElement hider : hiderFields) {
                if (!this.env.getElementUtils().hides(hider, hidden)) continue;
                it.remove();
            }
        }
        return results;
    }

    protected void doOriginalStatesField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        if (!classElement.equals(fieldElement.getEnclosingElement())) {
            return;
        }
        if (entityMeta.hasOriginalStatesMeta()) {
            throw new AptException((MessageResource)Message.DOMA4125, this.env, (Element)fieldElement, new Object[0]);
        }
        if (!TypeMirrorUtil.isSameType(fieldElement.asType(), classElement.asType(), this.env)) {
            throw new AptException((MessageResource)Message.DOMA4135, this.env, (Element)fieldElement, classElement.getQualifiedName());
        }
        TypeElement entityElement = ElementUtil.toTypeElement(fieldElement.getEnclosingElement(), this.env);
        if (entityElement == null) {
            throw new AptIllegalStateException(fieldElement.toString());
        }
        OriginalStatesMeta changedPropertiesMeta = new OriginalStatesMeta(entityElement, fieldElement, this.env);
        entityMeta.setOriginalStatesMeta(changedPropertiesMeta);
    }

    protected void doEntityPropertyMeta(VariableElement fieldElement, EntityMeta entityMeta) {
        this.validateFieldAnnotation(fieldElement, entityMeta);
        EntityPropertyMeta propertyMeta = this.propertyMetaFactory.createEntityPropertyMeta(fieldElement, entityMeta);
        entityMeta.addPropertyMeta(propertyMeta);
    }

    protected void validateFieldAnnotation(VariableElement fieldElement, EntityMeta entityMeta) {
        TypeElement foundAnnotationTypeElement = null;
        for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
            if (typeElement.getAnnotation(EntityField.class) == null) continue;
            if (foundAnnotationTypeElement != null) {
                throw new AptException((MessageResource)Message.DOMA4086, this.env, (Element)fieldElement, foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName());
            }
            foundAnnotationTypeElement = typeElement;
        }
    }

    protected void validateGeneratedId(TypeElement classElement, EntityMeta entityMeta) {
        if (entityMeta.hasGeneratedIdPropertyMeta() && entityMeta.getIdPropertyMetas().size() > 1) {
            throw new AptException((MessageResource)Message.DOMA4036, this.env, (Element)classElement, new Object[0]);
        }
    }
}

