/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.TypeKindVisitor6;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class QueryReturnMeta {
    protected final ProcessingEnvironment env;
    protected final ExecutableElement element;
    protected final TypeMirror type;
    protected final String typeName;
    protected final DataType dataType;

    public QueryReturnMeta(ExecutableElement methodElement, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)methodElement, (Object)env);
        this.element = methodElement;
        this.env = env;
        this.type = methodElement.getReturnType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        this.dataType = this.createDataType(methodElement, this.type, env);
    }

    protected DataType createDataType(ExecutableElement methodElement, TypeMirror type, ProcessingEnvironment env) {
        IterableType iterableType = IterableType.newInstance(type, env);
        if (iterableType != null) {
            if (iterableType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4109, env, (Element)methodElement, this.typeName);
            }
            if (iterableType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4113, env, (Element)methodElement, this.typeName);
            }
            return iterableType;
        }
        EntityType entityType = EntityType.newInstance(type, env);
        if (entityType != null) {
            return entityType;
        }
        DomainType domainType = DomainType.newInstance(type, env);
        if (domainType != null) {
            return domainType;
        }
        BasicType basicType = BasicType.newInstance(type, env);
        if (basicType != null) {
            return basicType;
        }
        MapType mapType = MapType.newInstance(type, env);
        if (mapType != null) {
            return mapType;
        }
        return AnyType.newInstance(type, env);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeNameAsTypeParameter() {
        return this.dataType.getTypeNameAsTypeParameter();
    }

    public boolean isPrimitiveInt() {
        return this.type.getKind() == TypeKind.INT;
    }

    public boolean isPrimitiveIntArray() {
        return this.type.accept(new TypeKindVisitor6<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return t.getComponentType().getKind() == TypeKind.INT;
            }
        }, null);
    }

    public boolean isPrimitiveVoid() {
        return this.type.getKind() == TypeKind.VOID;
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public DataType getDataType() {
        return this.dataType;
    }
}

