/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Dao;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;

public class DaoMirror {
    protected final AnnotationMirror annotationMirror;
    protected final ProcessingEnvironment env;
    protected AnnotationValue config;
    protected TypeMirror configValue;

    protected DaoMirror(AnnotationMirror annotationMirror, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)annotationMirror, (Object)env);
        this.annotationMirror = annotationMirror;
        this.env = env;
    }

    public static DaoMirror newInstance(TypeElement interfase, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(interfase, Dao.class, env);
        if (annotationMirror == null) {
            return null;
        }
        DaoMirror result = new DaoMirror(annotationMirror, env);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if (!"config".equals(name)) continue;
            result.config = value;
            result.configValue = AnnotationValueUtil.toType(value);
            if (result.configValue != null) continue;
            throw new AptIllegalStateException("config");
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getConfig() {
        return this.config;
    }

    public TypeMirror getConfigValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.config);
        if (value == null) {
            throw new AptIllegalStateException("config");
        }
        return value;
    }

    public boolean hasUserDefinedConfig() {
        return !TypeMirrorUtil.isSameType(this.configValue, Config.class, this.env);
    }
}

