/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.Function;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class FunctionMirror {
    protected final AnnotationMirror annotationMirror;
    protected final String defaultName;
    protected AnnotationValue catalog;
    protected AnnotationValue schema;
    protected AnnotationValue name;
    protected AnnotationValue queryTimeout;
    protected AnnotationValue mapKeyNaming;

    protected FunctionMirror(AnnotationMirror annotationMirror, String defaltName) {
        AssertionUtil.assertNotNull((Object)annotationMirror, (Object)defaltName);
        this.annotationMirror = annotationMirror;
        this.defaultName = defaltName;
    }

    public static FunctionMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(method, Function.class, env);
        if (annotationMirror == null) {
            return null;
        }
        FunctionMirror result = new FunctionMirror(annotationMirror, method.getSimpleName().toString());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("catalog".equals(name)) {
                result.catalog = value;
                continue;
            }
            if ("schema".equals(name)) {
                result.schema = value;
                continue;
            }
            if ("name".equals(name)) {
                result.name = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if (!"mapKeyNaming".equals(name)) continue;
            result.mapKeyNaming = value;
        }
        return result;
    }

    public String getQualifiedName() {
        String catalogValue = AnnotationValueUtil.toString(this.catalog);
        String schemaValue = AnnotationValueUtil.toString(this.schema);
        String nameValue = AnnotationValueUtil.toString(this.name);
        StringBuilder buf = new StringBuilder();
        if (catalogValue != null && !catalogValue.isEmpty()) {
            buf.append(catalogValue);
            buf.append(".");
        }
        if (schemaValue != null && !schemaValue.isEmpty()) {
            buf.append(schemaValue);
            buf.append(".");
        }
        if (nameValue != null && !nameValue.isEmpty()) {
            buf.append(nameValue);
        } else {
            buf.append(this.defaultName);
        }
        return buf.toString();
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException("queryTimeout");
        }
        return value;
    }

    public AnnotationValue getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public MapKeyNamingType getMapKeyNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.mapKeyNaming);
        if (enumConstant == null) {
            throw new AptIllegalStateException("mapKeyNaming");
        }
        return MapKeyNamingType.valueOf(enumConstant.getSimpleName().toString());
    }
}

