/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.wrapper.Wrapper;

public class BasicSingleResultHandler<V>
implements ResultSetHandler<V> {
    protected final Wrapper<V> wrapper;
    protected final boolean primitveResult;

    public BasicSingleResultHandler(Wrapper<V> wrapper, boolean primitveResult) {
        AssertionUtil.assertNotNull(wrapper);
        if (primitveResult) {
            AssertionUtil.assertNotNull(wrapper.getDefault());
        }
        this.wrapper = wrapper;
        this.primitveResult = primitveResult;
    }

    @Override
    public V handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        V result;
        BasicFetcher fetcher = new BasicFetcher(query);
        if (resultSet.next()) {
            fetcher.fetch(resultSet, this.wrapper);
            if (resultSet.next()) {
                PreparedSql sql = query.getSql();
                throw new NonUniqueResultException(sql);
            }
        } else if (query.isResultEnsured()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        if ((result = this.wrapper.get()) == null && this.primitveResult && (result = this.wrapper.getDefault()) == null) {
            AssertionUtil.assertNotNull(result);
        }
        return result;
    }
}

