/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.query.AutoModifyQuery;
import org.seasar.doma.internal.jdbc.query.DeleteQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoDeleteQuery<E>
extends AutoModifyQuery<E>
implements DeleteQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoDeleteQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.entityType, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.executable = true;
        this.preDelete();
        this.prepareIdAndVersionPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preDelete() {
        AutoPreDeleteContext context = new AutoPreDeleteContext(this.entityType);
        this.entityType.preDelete(this.entity, context);
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.DELETE);
        builder.appendSql("delete from ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            for (EntityPropertyType p : this.idPropertyTypes) {
                builder.appendSql(p.getColumnName());
                builder.appendSql(" = ");
                builder.appendWrapper(p.getWrapper(this.entity));
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (this.idPropertyTypes.size() == 0) {
                builder.appendSql(" where ");
            } else {
                builder.appendSql(" and ");
            }
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.entity));
        }
        this.sql = builder.build();
    }

    @Override
    public void complete() {
        this.postDelete();
    }

    protected void postDelete() {
        AutoPostDeleteContext context = new AutoPostDeleteContext(this.entityType);
        this.entityType.postDelete(this.entity, context);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoPostDeleteContext
    extends AbstractPostDeleteContext {
        public AutoPostDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class AutoPreDeleteContext
    extends AbstractPreDeleteContext {
        public AutoPreDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }
}

