/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.sql.Statement;
import java.util.ArrayList;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.query.AutoModifyQuery;
import org.seasar.doma.internal.jdbc.query.InsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoInsertQuery<E>
extends AutoModifyQuery<E>
implements InsertQuery {
    protected boolean nullExcluded;
    protected GeneratedIdPropertyType<? super E, E, ?, ?> generatedIdPropertyType;
    protected IdGenerationConfig idGenerationConfig;

    public AutoInsertQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.entityType, this.entity, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.executable = true;
        this.preInsert();
        this.prepareIdAndVersionPropertyTypes();
        this.prepareOptions();
        this.prepareTargetPropertyType();
        this.prepareIdValue();
        this.prepareVersionValue();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preInsert() {
        AutoPreInsertContext context = new AutoPreInsertContext(this.entityType);
        this.entityType.preInsert(this.entity, context);
    }

    @Override
    protected void prepareIdAndVersionPropertyTypes() {
        super.prepareIdAndVersionPropertyTypes();
        this.generatedIdPropertyType = this.entityType.getGeneratedIdPropertyType();
        if (this.generatedIdPropertyType != null) {
            this.idGenerationConfig = new IdGenerationConfig(this.config, this.entityType);
            this.generatedIdPropertyType.validateGenerationStrategy(this.idGenerationConfig);
            this.autoGeneratedKeysSupported = this.generatedIdPropertyType.isAutoGeneratedKeysSupported(this.idGenerationConfig);
        }
    }

    protected void prepareTargetPropertyType() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType<Object, ?> entityPropertyType : this.entityType.getEntityPropertyTypes()) {
            if (!entityPropertyType.isInsertable()) continue;
            if (entityPropertyType.isId()) {
                if (entityPropertyType != this.generatedIdPropertyType || this.generatedIdPropertyType.isIncluded(this.idGenerationConfig)) {
                    this.targetPropertyTypes.add(entityPropertyType);
                }
                if (this.generatedIdPropertyType != null || entityPropertyType.getWrapper(this.entity).get() != null) continue;
                throw new JdbcException((MessageResource)Message.DOMA2020, this.entityType.getName(), entityPropertyType.getName());
            }
            if (entityPropertyType.isVersion()) {
                this.targetPropertyTypes.add(entityPropertyType);
                continue;
            }
            if (this.nullExcluded && entityPropertyType.getWrapper(this.entity).get() == null || !this.isTargetPropertyName(entityPropertyType.getName())) continue;
            this.targetPropertyTypes.add(entityPropertyType);
        }
    }

    protected void prepareIdValue() {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            this.generatedIdPropertyType.preInsert(this.entity, this.idGenerationConfig);
        }
    }

    protected void prepareVersionValue() {
        if (this.versionPropertyType != null) {
            this.versionPropertyType.setIfNecessary(this.entity, 1);
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.INSERT);
        builder.appendSql("insert into ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        builder.appendSql(" (");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName());
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(") values (");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendWrapper(p.getWrapper(this.entity));
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(")");
        this.sql = builder.build();
    }

    @Override
    public void generateId(Statement statement) {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            this.generatedIdPropertyType.postInsert(this.entity, this.idGenerationConfig, statement);
        }
    }

    @Override
    public void complete() {
        this.postInsert();
    }

    protected void postInsert() {
        AutoPostInsertContext context = new AutoPostInsertContext(this.entityType);
        this.entityType.postInsert(this.entity, context);
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    protected static class AutoPostInsertContext
    extends AbstractPostInsertContext {
        public AutoPostInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class AutoPreInsertContext
    extends AbstractPreInsertContext {
        public AutoPreInsertContext(EntityType<?> entityType) {
            super(entityType);
        }
    }
}

