/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.Iterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.query.BatchDeleteQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileBatchDeleteQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchDeleteQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchDeleteQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_DELETE);
    }

    @Override
    public void prepare() {
        super.prepare();
        Iterator it = this.elements.iterator();
        if (it.hasNext()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareSqlFile();
            this.prepareOptions();
            this.prepareOptimisticLock();
            this.prepareSql();
        } else {
            return;
        }
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareSql();
        }
        AssertionUtil.assertEquals(this.elements.size(), this.sqls.size());
    }

    protected void preDelete() {
        if (this.entityHandler != null) {
            this.entityHandler.preDelete();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            for (Object element : this.elements) {
                this.currentEntity = element;
                this.entityHandler.postDelete();
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFileBatchPostDeleteContext
    extends AbstractPostDeleteContext {
        public SqlFileBatchPostDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class SqlFileBatchPreDeleteContext
    extends AbstractPreDeleteContext {
        public SqlFileBatchPreDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preDelete() {
            SqlFileBatchPreDeleteContext context = new SqlFileBatchPreDeleteContext(this.entityType);
            this.entityType.preDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
        }

        protected void postDelete() {
            SqlFileBatchPostDeleteContext context = new SqlFileBatchPostDeleteContext(this.entityType);
            this.entityType.postDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchDeleteQuery.this.versionIgnored && !SqlFileBatchDeleteQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchDeleteQuery.this.optimisticLockCheckRequired = true;
            }
        }
    }
}

