/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.Iterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileBatchUpdateQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchUpdateQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchUpdateQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_UPDATE);
    }

    @Override
    public void prepare() {
        super.prepare();
        Iterator it = this.elements.iterator();
        if (it.hasNext()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareSqlFile();
            this.prepareOptions();
            this.prepareOptimisticLock();
            this.prepareSql();
        } else {
            return;
        }
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareSql();
        }
        AssertionUtil.assertEquals(this.elements.size(), this.sqls.size());
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersions() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersions();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            for (Object element : this.elements) {
                this.currentEntity = element;
                this.entityHandler.postUpdate();
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFileBatchPostUpdateContext
    extends AbstractPostUpdateContext {
        public SqlFileBatchPostUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFileBatchPreUpdateContext
    extends AbstractPreUpdateContext {
        public SqlFileBatchPreUpdateContext(EntityType<?> entityType) {
            super(entityType);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preUpdate() {
            SqlFileBatchPreUpdateContext context = new SqlFileBatchPreUpdateContext(this.entityType);
            this.entityType.preUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
        }

        protected void postUpdate() {
            SqlFileBatchPostUpdateContext context = new SqlFileBatchPostUpdateContext(this.entityType);
            this.entityType.postUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored && !SqlFileBatchUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersions() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored) {
                for (Object entity : SqlFileBatchUpdateQuery.this.elements) {
                    this.versionPropertyType.increment(entity);
                }
            }
        }
    }
}

