/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.BlockNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.ForBlockNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class ForBlockNode
extends AbstractSqlNode
implements BlockNode {
    public static final String HAS_NEXT_SUFFIX = "_has_next";
    public static final String INDEX_SUFFIX = "_index";
    protected ForNode forNode;
    protected EndNode endNode;

    public void setForNode(ForNode forNode) {
        this.forNode = forNode;
        this.addNodeInternal(forNode);
    }

    public ForNode getForNode() {
        return this.forNode;
    }

    @Override
    public void setEndNode(EndNode endNode) {
        this.endNode = endNode;
        this.addNodeInternal(endNode);
    }

    public EndNode getEndNode() {
        return this.endNode;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    protected void addNodeInternal(SqlNode child) {
        if (child != null) {
            super.addNode(child);
        }
    }

    @Override
    public ForBlockNode copy() {
        ForBlockNode clone = new ForBlockNode();
        if (this.forNode != null) {
            clone.forNode = this.forNode.copy();
        }
        if (this.endNode != null) {
            clone.endNode = this.endNode.copy();
        }
        for (SqlNode child : this.children) {
            clone.addNodeInternal(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof ForBlockNodeVisitor) {
            ForBlockNodeVisitor v = (ForBlockNodeVisitor)visitor;
            return v.visitForBlockNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }
}

