/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;

public final class MethodUtil {
    public static <T> T invoke(Method method, Object target, Object ... params) throws WrapException {
        AssertionUtil.assertNotNull(method);
        try {
            Object result = method.invoke(target, params);
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw new WrapException(e);
        }
        catch (IllegalAccessException e) {
            throw new WrapException(e);
        }
        catch (InvocationTargetException e) {
            throw new WrapException(e);
        }
    }

    public static String createSignature(String methodName, Class<?>[] paramTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append(methodName);
        buf.append("(");
        for (Class<?> paramType : paramTypes) {
            if (paramType.isArray()) {
                buf.append(paramType.getComponentType().getName());
                buf.append("[]");
            } else {
                buf.append(paramType.getName());
            }
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return buf.toString();
    }
}

