/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.seasar.doma.message.Message;

public class SimpleDataSource
implements DataSource {
    protected static final String UNABLE_TO_ESTABLISH_CONNECTION = "08001";
    protected String url;
    protected String user;
    protected String password;
    protected final Properties properties = new Properties();

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Properties info = new Properties();
        info.putAll((Map<?, ?>)this.properties);
        if (this.user != null) {
            info.setProperty("user", this.user);
        }
        if (this.password != null) {
            info.setProperty("password", this.password);
        }
        return this.getConnectionInternal(info);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        Properties info = new Properties();
        info.putAll((Map<?, ?>)this.properties);
        if (user != null) {
            info.setProperty("user", user);
        }
        if (password != null) {
            info.setProperty("password", password);
        }
        return this.getConnectionInternal(info);
    }

    protected Connection getConnectionInternal(Properties info) throws SQLException {
        if (this.url == null) {
            throw new SQLException(Message.DOMA5002.getMessage(new Object[0]));
        }
        try {
            return DriverManager.getConnection(this.url, info);
        }
        catch (SQLException e) {
            if (UNABLE_TO_ESTABLISH_CONNECTION.equals(e.getSQLState())) {
                throw new SQLException(Message.DOMA5001.getMessage(new Object[0]), UNABLE_TO_ESTABLISH_CONNECTION, e);
            }
            throw e;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unwrap method is unsupported.");
    }
}

