/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.OracleForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.OraclePagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.JdbcMappingFunction;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormatter;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.jdbc.type.AbstractResultSetType;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.jdbc.type.JdbcTypes;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

public class OracleDialect
extends StandardDialect {
    protected static final int UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODE = 1;
    protected static final JdbcType<ResultSet> RESULT_SET = new OracleResultSetType();

    public OracleDialect() {
        this(new OracleJdbcMappingVisitor(), new OracleSqlLogFormattingVisitor(), new OracleExpressionFunctions());
    }

    public OracleDialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new OracleSqlLogFormattingVisitor(), new OracleExpressionFunctions());
    }

    public OracleDialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new OracleJdbcMappingVisitor(), sqlLogFormattingVisitor, new OracleExpressionFunctions());
    }

    public OracleDialect(ExpressionFunctions expressionFunctions) {
        this(new OracleJdbcMappingVisitor(), new OracleSqlLogFormattingVisitor(), expressionFunctions);
    }

    public OracleDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new OracleExpressionFunctions());
    }

    public OracleDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public boolean supportsBatchUpdateResults() {
        return false;
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        OracleForUpdateTransformer transformer = new OracleForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        OraclePagingTransformer transformer = new OraclePagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        int code = this.getErrorCode(sqlException);
        return 1 == code;
    }

    @Override
    public PreparedSql getSequenceNextValSql(String qualifiedSequenceName, long allocationSize) {
        if (qualifiedSequenceName == null) {
            throw new DomaNullPointerException("qualifiedSequenceName");
        }
        String rawSql = "select " + qualifiedSequenceName + ".nextval from dual";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    public boolean supportsIdentity() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return true;
    }

    @Override
    public boolean supportsResultSetReturningAsOutParameter() {
        return true;
    }

    @Override
    public JdbcType<ResultSet> getResultSetType() {
        return RESULT_SET;
    }

    @Override
    public String getScriptBlockDelimiter() {
        return "/";
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new OracleScriptBlockContext();
    }

    public static class OracleScriptBlockContext
    extends StandardDialect.StandardScriptBlockContext {
        protected OracleScriptBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "or", "replace", "triger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    public static class OracleExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
        private static final char[] DEFAULT_WILDCARDS = new char[]{'%', '_', '\uff05', '\uff3f'};

        public OracleExpressionFunctions() {
            super(DEFAULT_WILDCARDS);
        }
    }

    public static class OracleSqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
        protected DateFormatter dateFormatter = new DateFormatter();
        protected TimeFormatter timeFormatter = new TimeFormatter();
        protected TimestampFormatter timestampFormatter = new TimestampFormatter();
        protected UtilDateFormatter utilDateFormatter = new UtilDateFormatter();

        @Override
        public String visitBooleanWrapper(BooleanWrapper wrapper, SqlLogFormattingFunction p) throws RuntimeException {
            return p.apply(wrapper, JdbcTypes.INTEGER_ADAPTIVE_BOOLEAN);
        }

        @Override
        public String visitDateWrapper(DateWrapper wrapper, SqlLogFormattingFunction p) {
            return p.apply(wrapper, this.dateFormatter);
        }

        @Override
        public String visitTimeWrapper(TimeWrapper wrapper, SqlLogFormattingFunction p) {
            return p.apply(wrapper, this.timeFormatter);
        }

        @Override
        public String visitTimestampWrapper(TimestampWrapper wrapper, SqlLogFormattingFunction p) {
            return p.apply(wrapper, this.timestampFormatter);
        }

        @Override
        public String visitUtilDateWrapper(UtilDateWrapper wrapper, SqlLogFormattingFunction p) {
            return p.apply(wrapper, this.utilDateFormatter);
        }

        protected static class UtilDateFormatter
        implements SqlLogFormatter<java.util.Date> {
            protected UtilDateFormatter() {
            }

            @Override
            public String convertToLogFormat(java.util.Date value) {
                if (value == null) {
                    return "null";
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return "timestamp'" + dateFormat.format(value) + "'";
            }
        }

        protected static class TimestampFormatter
        implements SqlLogFormatter<Timestamp> {
            protected TimestampFormatter() {
            }

            @Override
            public String convertToLogFormat(Timestamp value) {
                if (value == null) {
                    return "null";
                }
                return "timestamp'" + value + "'";
            }
        }

        protected static class TimeFormatter
        implements SqlLogFormatter<Time> {
            protected TimeFormatter() {
            }

            @Override
            public String convertToLogFormat(Time value) {
                if (value == null) {
                    return "null";
                }
                return "time'" + value + "'";
            }
        }

        protected static class DateFormatter
        implements SqlLogFormatter<Date> {
            protected DateFormatter() {
            }

            @Override
            public String convertToLogFormat(Date value) {
                if (value == null) {
                    return "null";
                }
                return "date'" + value + "'";
            }
        }
    }

    public static class OracleJdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
        @Override
        public Void visitBooleanWrapper(BooleanWrapper wrapper, JdbcMappingFunction p) throws SQLException {
            return (Void)p.apply(wrapper, JdbcTypes.INTEGER_ADAPTIVE_BOOLEAN);
        }
    }

    public static class OracleResultSetType
    extends AbstractResultSetType {
        protected static int CURSOR = -10;

        public OracleResultSetType() {
            super(CURSOR);
        }
    }
}

