/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class BigDecimalWrapper
extends AbstractWrapper<BigDecimal>
implements NumberWrapper<BigDecimal> {
    public BigDecimalWrapper() {
    }

    public BigDecimalWrapper(BigDecimal value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        if (v instanceof BigDecimal) {
            super.set((BigDecimal)v);
        } else if (v instanceof BigInteger) {
            super.set(new BigDecimal((BigInteger)v));
        } else {
            super.set(new BigDecimal(v.doubleValue()));
        }
    }

    @Override
    public void increment() {
        BigDecimal value = (BigDecimal)this.doGet();
        if (value != null) {
            this.doSet(value.add(BigDecimal.ONE));
        }
    }

    @Override
    public void decrement() {
        BigDecimal value = (BigDecimal)this.doGet();
        if (value != null) {
            this.doSet(value.subtract(BigDecimal.ONE));
        }
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof BigDecimalWrapperVisitor) {
            BigDecimalWrapperVisitor v = (BigDecimalWrapperVisitor)visitor;
            return v.visitBigDecimalWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

