/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.EnumWrapperVisitor;
import org.seasar.doma.wrapper.WrapperVisitor;

public class EnumWrapper<E extends Enum<E>>
extends AbstractWrapper<E> {
    protected final Class<E> enumClass;

    public EnumWrapper(Class<E> enumClass) {
        this(enumClass, null);
    }

    public EnumWrapper(Class<E> enumClass, E value) {
        super(value);
        if (enumClass == null) {
            throw new DomaNullPointerException("enumClass");
        }
        this.enumClass = enumClass;
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof EnumWrapperVisitor) {
            EnumWrapperVisitor v = (EnumWrapperVisitor)visitor;
            return v.visitEnumWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

