/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.xml.DOMConfigurator;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static StringBuffer sbuf = new StringBuffer();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$org$apache$log4j$spi$Configurator;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] l, String[] r) {
        int len = l.length + r.length;
        String[] a = new String[len];
        System.arraycopy(l, 0, a, 0, l.length);
        System.arraycopy(r, 0, a, l.length, r.length);
        return a;
    }

    public static String convertSpecialChars(String s) {
        int len = s.length();
        StringBuffer sbuf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int c;
            if ((c = s.charAt(i++)) == 92) {
                if ((c = s.charAt(i++)) == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 8) {
                    c = 8;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 92) {
                    c = 92;
                }
            }
            sbuf.append((char)c);
        }
        return sbuf.toString();
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            LogLog.debug("Was not allowed to read system property \"" + key + "\".");
            return def;
        }
    }

    public static Object instantiateByKey(Properties props, String key, Class superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            LogLog.error("Could not find value for key " + key);
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static int toInt(String value, int dEfault) {
        if (value != null) {
            String s = value.trim();
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                LogLog.error("[" + s + "] is not in proper int form.");
                e.printStackTrace();
            }
        }
        return dEfault;
    }

    public static Priority toPriority(String value, Priority defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        int hashIndex = value.indexOf(35);
        if (hashIndex == -1) {
            return Priority.toPriority(value, defaultValue);
        }
        Priority result = defaultValue;
        String clazz = value.substring(hashIndex + 1);
        String priorityName = value.substring(0, hashIndex);
        LogLog.debug("toPriority:class=[" + clazz + "]" + ":pri=[" + priorityName + "]");
        try {
            Class<?> customPriority = Class.forName(clazz);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OptionConverter.class$("java.lang.String")) : class$java$lang$String, class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = OptionConverter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority};
            Method toPriorityMethod = customPriority.getMethod("toPriority", paramTypes);
            Object[] params = new Object[]{priorityName, defaultValue};
            Object o = toPriorityMethod.invoke(null, params);
            result = (Priority)o;
        }
        catch (ClassNotFoundException e) {
            LogLog.warn("custom priority class [" + clazz + "] not found.");
        }
        catch (NoSuchMethodException e) {
            LogLog.warn("custom priority class [" + clazz + "]" + " does not have a constructor which takes one string parameter", e);
        }
        catch (InvocationTargetException e) {
            LogLog.warn("custom priority class [" + clazz + "]" + " could not be instantiated", e);
        }
        catch (ClassCastException e) {
            LogLog.warn("class [" + clazz + "] is not a subclass of org.apache.log4j.Priority", e);
        }
        catch (IllegalAccessException e) {
            LogLog.warn("class [" + clazz + "] cannot be instantiated due to access restrictions", e);
        }
        catch (Exception e) {
            LogLog.warn("class [" + clazz + "], priority [" + priorityName + "] conversion failed.", e);
        }
        return result;
    }

    public static long toFileSize(String value, long dEfault) {
        if (value == null) {
            return dEfault;
        }
        String s = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s = s.substring(0, index);
        } else {
            index = s.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s = s.substring(0, index);
            } else {
                index = s.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s = s.substring(0, index);
                }
            }
        }
        if (s != null) {
            try {
                return Long.valueOf(s) * multiplier;
            }
            catch (NumberFormatException e) {
                LogLog.error("[" + s + "] is not in proper int form.");
                LogLog.error("[" + value + "] not in expected format.", e);
            }
        }
        return dEfault;
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            LogLog.error("Bad option value [" + value + "].", e);
            return value;
        }
    }

    public static Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class<?> classObj = Class.forName(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    LogLog.error("A \"" + className + "\" object is not assignable to a \"" + superClass.getName() + "\" variable.");
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e) {
                LogLog.error("Could not instantiate class [" + className + "].", e);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        sbuf.setLength(0);
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                sbuf.append(replacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    public static void selectAndConfigure(URL url, Hierarchy hierarchy) {
        String clazz = url.getRef();
        Configurator configurator = null;
        if (clazz != null) {
            LogLog.debug("Preferred configurator class: " + clazz);
            configurator = (Configurator)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Configurator == null ? (class$org$apache$log4j$spi$Configurator = OptionConverter.class$("org.apache.log4j.spi.Configurator")) : class$org$apache$log4j$spi$Configurator, null);
            if (configurator == null) {
                LogLog.error("Could not instantiate configurator [" + clazz + "].");
                return;
            }
        } else {
            String filename = url.getFile();
            if (filename != null && filename.endsWith(".xml")) {
                try {
                    configurator = new DOMConfigurator();
                }
                catch (NoClassDefFoundError e) {
                    LogLog.warn("Could not find DOMConfigurator!", e);
                    return;
                }
            } else {
                configurator = new PropertyConfigurator();
            }
        }
        configurator.doConfigure(url, hierarchy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

