/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.RotatingLogStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class HttpLogWriter
implements Flushable,
Closeable {
    public static final int DEF_LOG_ROTATE_BYTES = 524288000;
    private final String LOG_DATE_FORMAT = "[dd/MMM/yyyy:HH:mm:ss Z]";
    private final String FILENAME_DATE_FORMAT = "yyyyMMdd";
    private String logDateFormat = "[dd/MMM/yyyy:HH:mm:ss Z]";
    private TimeZone timeZone;
    private ThreadLocal<SimpleDateFormat> threadlocalDateFormat = new ThreadLocal();
    private final OutputStream logStream;

    public HttpLogWriter(String basename, int port, int logRotateBytes, TimeZone tz) throws IOException {
        if (basename == null) {
            throw new NullPointerException("basename must be non-null");
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        int dotpos = hostname.indexOf(46);
        if (dotpos != -1) {
            hostname = hostname.substring(0, dotpos);
        }
        this.setTimeZone(tz);
        String fn = basename + ".from_" + hostname + ".port" + port + ".starts";
        SimpleDateFormat filenameDateFormat = new SimpleDateFormat("yyyyMMdd");
        filenameDateFormat.setTimeZone(this.timeZone);
        RotatingLogStream rLogStream = new RotatingLogStream(fn, basename, filenameDateFormat);
        rLogStream.setRotateSize(logRotateBytes);
        this.logStream = rLogStream;
    }

    public HttpLogWriter(String basename, int port, int logRotateBytes) throws IOException {
        this(basename, port, logRotateBytes, TimeZone.getDefault());
    }

    public HttpLogWriter(String basename, int port) throws IOException {
        this(basename, port, 524288000, TimeZone.getDefault());
    }

    public HttpLogWriter(OutputStream outStream) {
        this.setTimeZone(TimeZone.getDefault());
        this.logStream = outStream;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
        this.threadlocalDateFormat = new ThreadLocal();
    }

    public SimpleDateFormat getLogDateFormat() {
        SimpleDateFormat sdf = this.threadlocalDateFormat.get();
        if (sdf == null) {
            sdf = this.createLogDateFormat();
            this.threadlocalDateFormat.set(sdf);
        }
        return sdf;
    }

    private SimpleDateFormat createLogDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat(this.logDateFormat);
        sdf.setTimeZone(this.timeZone);
        return sdf;
    }

    public void setLogDateFormat(String dateFormat) {
        this.logDateFormat = dateFormat;
        this.threadlocalDateFormat = new ThreadLocal();
    }

    public void log(String line) throws IOException {
        byte[] bytes;
        try {
            bytes = line.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported?");
        }
        this.logStream.write(bytes);
    }

    public void flush() throws IOException {
        this.logStream.flush();
    }

    public void close() throws IOException {
        this.logStream.close();
    }

    public static Entry createEntry(HttpServletRequest req) {
        return HttpLogWriter.createEntry(req, req.getQueryString());
    }

    public static Entry createEntry(HttpServletRequest req, String queryString) {
        Entry e = new Entry();
        e.time = System.currentTimeMillis();
        e.request = HttpLogWriter.generateEntryRequest(req, req.getRequestURI(), queryString);
        e.originatingHost = req.getRemoteAddr();
        e.referer = req.getHeader("referer");
        e.acceptLanguage = req.getHeader("accept-language");
        e.userAgent = req.getHeader("user-agent");
        e.httpHost = req.getServerName();
        e.cookies = req.getHeader("cookie");
        return e;
    }

    public String generateLogLine(Entry e) {
        StringBuilder sb = new StringBuilder(160);
        HttpLogWriter.appendField(sb, e.originatingHost);
        sb.append(" - - ");
        sb.append(this.getLogDateFormat().format(new Date(e.time)));
        sb.append(" \"");
        HttpLogWriter.appendField(sb, e.request);
        sb.append("\" ");
        sb.append(e.responseCode);
        sb.append(' ');
        sb.append(e.responseBytes);
        sb.append(" \"");
        HttpLogWriter.appendField(sb, e.referer);
        sb.append("\" \"");
        HttpLogWriter.appendField(sb, e.userAgent);
        sb.append("\"\n");
        return sb.toString();
    }

    public void log(Entry e) throws IOException {
        this.log(this.generateLogLine(e));
    }

    public static String generateEntryRequest(HttpServletRequest req, String requestURI, String queryString) {
        StringBuilder sb = new StringBuilder();
        sb.append(req.getMethod());
        sb.append(' ');
        sb.append(requestURI);
        if (queryString != null) {
            sb.append('?');
            sb.append(queryString);
        }
        sb.append(' ');
        String proto = req.getProtocol();
        int eolpos = CharMatcher.anyOf("\r\n").indexIn(proto);
        if (eolpos != -1) {
            proto = proto.substring(0, eolpos);
        }
        sb.append(proto);
        return sb.toString();
    }

    protected static void appendField(StringBuilder chars, @Nullable String val) {
        if (val != null) {
            chars.append(val.replace('\t', ' ').replace('\n', ' '));
        }
    }

    public static class Entry {
        public long time;
        public String request;
        public String originatingHost;
        public int responseCode = 200;
        public int responseBytes = 0;
        public String referer;
        public String userAgent;
        public String httpHost;
        public String cookies;
        public String timing = "0";
        public String acceptLanguage;

        public Entry(Entry e) {
            this.time = e.time;
            this.request = e.request;
            this.originatingHost = e.originatingHost;
            this.responseCode = e.responseCode;
            this.responseBytes = e.responseBytes;
            this.referer = e.referer;
            this.userAgent = e.userAgent;
            this.httpHost = e.httpHost;
            this.cookies = e.cookies;
            this.timing = e.timing;
        }

        public Entry() {
        }
    }
}

