/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

@Deprecated
public class Log {
    private static String fileInfo = null;
    private static String logDir = null;
    private static String progName = null;
    private static BufferedWriter logInfo = null;
    private static BufferedWriter logError = null;
    private static BufferedWriter logFatal = null;
    private static BufferedWriter logOperator = null;
    public static StringBuffer logMemorizedError = null;
    private static int logLevel = 1;
    private static final long ROTATE_AT = 1992200000L;
    private static final long CHECK_EVERY = 1000L;
    private static int lastRoatationCheck = 0;
    private static boolean rotateDaily = true;
    private static GregorianCalendar timeToRotate = null;

    public static synchronized void info(String s) {
        if (logLevel < 1) {
            return;
        }
        if (null != logInfo) {
            Log.checkRotation();
            Log.writeLogFile(logInfo, s, "I", true);
        }
    }

    public static synchronized void info(int level, String s) {
        if (logLevel < level) {
            return;
        }
        if (null != logInfo) {
            Log.checkRotation();
            Log.writeLogFile(logInfo, s, "I", true);
        }
    }

    public static synchronized void operator(String s) {
        s = s.replace('\n', ' ');
        if (null != logInfo) {
            Log.checkRotation();
            Log.writeLogFile(logInfo, s, "O", true);
        }
        if (null != logOperator) {
            Log.writeLogFile(logOperator, s, "@", false);
            if (logMemorizedError != null) {
                logMemorizedError.append(s);
            }
        }
    }

    public static synchronized void error(String s) {
        if (null != logError) {
            Log.writeLogFile(logError, s, "E", true);
        }
        if (null != logInfo) {
            Log.writeLogFile(logInfo, s, "E", true);
        }
    }

    public static synchronized void fatal(String s) {
        if (null != logFatal) {
            Log.writeLogFile(logFatal, s, "F", true);
        }
        if (null != logError) {
            Log.writeLogFile(logError, s, "F", true);
        }
        if (null != logInfo) {
            Log.writeLogFile(logInfo, s, "F", true);
        }
        Log.end();
        System.exit(1);
    }

    public static void setLogLevel(int v_flag) {
        logLevel = v_flag;
    }

    public static synchronized void init(String directoryName, String programName, boolean date, boolean operator) {
        File directory = new File(directoryName);
        directory.mkdirs();
        logDir = directoryName;
        progName = programName;
        String fileName = new File(directory, programName).getPath();
        String dateString = "";
        Date now = new Date();
        timeToRotate = new GregorianCalendar();
        timeToRotate.setTime(now);
        timeToRotate.add(5, 1);
        timeToRotate.set(11, 0);
        timeToRotate.set(12, 0);
        timeToRotate.set(13, 0);
        if (date) {
            dateString = "." + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(now);
        }
        Log.setInfoLog(fileName + ".INFO" + dateString);
        Log.setErrorLog(fileName + ".ERROR" + dateString);
        Log.setFatalLog(fileName + ".FATAL" + dateString);
        if (operator) {
            Log.setOperatorLog(fileName + ".OPERATOR" + dateString);
        }
        logMemorizedError = null;
    }

    public static synchronized void init(String directory, String programName, boolean date) {
        Log.init(directory, programName, date, false);
    }

    public static synchronized void init(String directory, String programName, boolean date, int level) {
        Log.init(directory, programName, date, false, level);
    }

    public static synchronized void init(String directory, String programName, boolean date, boolean operator, int level) {
        Log.init(directory, programName, date, operator);
        logLevel = level;
        logMemorizedError = null;
    }

    public static synchronized void initMemorizedErrors() {
        logMemorizedError = new StringBuffer();
    }

    public static synchronized String getMemorizedErrors() {
        String errors;
        if (logMemorizedError != null) {
            errors = logMemorizedError.toString();
            logMemorizedError = new StringBuffer();
        } else {
            errors = "";
        }
        return errors;
    }

    public void setDailyRotation(boolean rotateDaily) {
        Log.rotateDaily = rotateDaily;
    }

    public static synchronized void end() {
        try {
            if (null != logInfo) {
                logInfo.flush();
                logInfo.close();
            }
            if (null != logError) {
                logError.flush();
                logError.close();
            }
            if (null != logFatal) {
                logFatal.flush();
                logFatal.close();
            }
        }
        catch (Exception e) {
            System.err.println("FATAL : Cannot open log file");
            System.exit(1);
        }
    }

    public static synchronized void setInfoLog(String fileName) {
        try {
            if (null != logInfo) {
                logInfo.flush();
                logInfo.close();
            }
            logInfo = Log.openLogFile(fileName);
            fileInfo = fileName;
        }
        catch (Exception e) {
            System.err.println("FATAL : Cannot open log file");
            System.exit(1);
        }
    }

    public static synchronized void setErrorLog(String fileName) {
        try {
            if (null != logError) {
                logError.flush();
                logError.close();
            }
            logError = Log.openLogFile(fileName);
        }
        catch (Exception e) {
            System.err.println("FATAL : Cannot open log file");
            System.exit(1);
        }
    }

    public static synchronized void setFatalLog(String fileName) {
        try {
            if (null != logFatal) {
                logFatal.flush();
                logFatal.close();
            }
            logFatal = Log.openLogFile(fileName);
        }
        catch (Exception e) {
            System.err.println("FATAL : Cannot open log file");
            System.exit(1);
        }
    }

    public static synchronized void setOperatorLog(String fileName) {
        try {
            if (null != logOperator) {
                logOperator.flush();
                logOperator.close();
            }
            logOperator = Log.openLogFile(fileName);
        }
        catch (Exception e) {
            System.err.println("FATAL : Cannot open/create the operator log file");
            System.exit(1);
        }
    }

    protected static synchronized void writeLogFile(BufferedWriter bw, String msg, String prefix, boolean stack) {
        String atLine = null;
        if (stack) {
            atLine = Log.getFilePosFromStack(4);
        }
        String dateString = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        String logLine = prefix + " " + dateString;
        if (atLine != null) {
            logLine = logLine + " " + atLine;
        }
        logLine = logLine + ": " + msg + "\n";
        try {
            bw.write(logLine);
            bw.flush();
        }
        catch (IOException e) {
            System.err.println("FATAL : Logging : " + logLine + " (" + e + ")");
        }
    }

    protected static synchronized void checkRotation() {
        if ((long)lastRoatationCheck > 1000L) {
            lastRoatationCheck = 0;
            if (new File(fileInfo).length() >= 1992200000L || rotateDaily && timeToRotate.getTime().before(new Date())) {
                Log.init(logDir, progName, true, logOperator != null);
            }
        }
        ++lastRoatationCheck;
    }

    protected static BufferedWriter openLogFile(String fileName) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
    }

    public static String getFilePosFromStack(int stackLevel) {
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        String result = null;
        StringTokenizer tokens = new StringTokenizer(((Object)out).toString(), "\n");
        if (tokens.countTokens() > stackLevel && tokens.nextToken().equals("java.lang.Exception")) {
            for (int i = 1; i < stackLevel; ++i) {
                tokens.nextToken();
            }
            String line = tokens.nextToken();
            int start = line.lastIndexOf(40);
            int end = line.lastIndexOf(41);
            if (start >= 0 && end >= 0 && end > start) {
                result = line.substring(start + 1, end);
            }
        }
        return result;
    }
}

