/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.synthesis;

import java.util.Locale;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Voice;

public class SynthesizerModeDesc
extends EngineModeDesc {
    private Voice[] voices;

    public SynthesizerModeDesc() {
        this.voices = null;
    }

    public SynthesizerModeDesc(String string, String string2, Locale locale, Boolean bl, Voice[] voiceArray) {
        super(string, string2, locale, bl);
        this.voices = voiceArray;
    }

    public SynthesizerModeDesc(Locale locale) {
        super(locale);
        this.voices = null;
    }

    public void addVoice(Voice voice) {
        int n = 0;
        if (this.voices != null) {
            n = this.voices.length;
        }
        Voice[] voiceArray = new Voice[n + 1];
        if (n > 0) {
            System.arraycopy(this.voices, 0, voiceArray, 0, n);
        }
        voiceArray[n] = voice;
        this.voices = voiceArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SynthesizerModeDesc)) {
            return false;
        }
        SynthesizerModeDesc synthesizerModeDesc = (SynthesizerModeDesc)object;
        if (!super.equals(object)) {
            return false;
        }
        if (this.voices == null != (synthesizerModeDesc.voices == null)) {
            return false;
        }
        if (this.voices != null) {
            if (this.voices.length != synthesizerModeDesc.voices.length) {
                return false;
            }
            int n = 0;
            while (n < this.voices.length) {
                if (this.voices[n] == null ? synthesizerModeDesc.voices[n] != null : !this.voices[n].equals(synthesizerModeDesc.voices[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public Voice[] getVoices() {
        return this.voices;
    }

    public boolean match(EngineModeDesc engineModeDesc) {
        if (!super.match(engineModeDesc)) {
            return false;
        }
        if (!(engineModeDesc instanceof SynthesizerModeDesc)) {
            return true;
        }
        SynthesizerModeDesc synthesizerModeDesc = (SynthesizerModeDesc)engineModeDesc;
        if (!super.match(synthesizerModeDesc)) {
            return false;
        }
        if (synthesizerModeDesc.voices != null) {
            if (this.voices == null) {
                return false;
            }
            int n = 0;
            while (n < synthesizerModeDesc.voices.length) {
                boolean bl = false;
                if (synthesizerModeDesc.voices[n] != null) {
                    int n2 = 0;
                    while (!bl && n2 < this.voices.length) {
                        if (this.voices[n2].match(synthesizerModeDesc.voices[n])) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                ++n;
            }
        }
        return true;
    }

    public void setVoices(Voice[] voiceArray) {
        this.voices = voiceArray;
    }
}

