/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.ControllerDesc;
import org.slim3.gen.desc.ControllerDescFactory;
import org.slim3.gen.generator.ControllerGenerator;
import org.slim3.gen.generator.ControllerTestCaseGenerator;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenControllerTask
extends AbstractGenJavaFileTask {
    protected String controllerPath;
    protected String superclassName = "org.slim3.controller.Controller";
    protected String testCaseSuperclassName = "org.slim3.tester.ControllerTestCase";
    protected boolean useView;

    public void setControllerPath(String controllerPath) {
        this.controllerPath = controllerPath;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public void setTestCaseSuperclassName(String testCaseSuperclassName) {
        this.testCaseSuperclassName = testCaseSuperclassName;
    }

    public void setUseView(boolean useView) {
        this.useView = useView;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.controllerPath == null) {
            throw new IllegalStateException("The controllerPath parameter is null.");
        }
        ControllerDesc controllerDesc = this.createControllerDesc();
        JavaFile javaFile = this.createJavaFile(controllerDesc);
        Generator generator = this.createControllerGenerator(controllerDesc);
        this.generateJavaFile(generator, javaFile);
        JavaFile testCaseJavaFile = this.createTestCaseJavaFile(controllerDesc);
        Generator testCaseGenerator = this.createControllerTestCaseGenerator(controllerDesc);
        this.generateJavaFile(testCaseGenerator, testCaseJavaFile);
    }

    private ControllerDesc createControllerDesc() throws IOException, XPathExpressionException {
        String path = this.controllerPath.startsWith("/") ? this.controllerPath : "/" + this.controllerPath;
        String controllerBasePackageName = this.getControllerBasePackageName();
        ControllerDescFactory factory = this.createControllerDescFactory(controllerBasePackageName);
        ControllerDesc controllerDesc = factory.createControllerDesc(path);
        return controllerDesc;
    }

    private String getControllerBasePackageName() throws IOException, XPathExpressionException {
        StringBuilder buf = new StringBuilder();
        WebConfig config = this.createWebConfig();
        buf.append(config.getRootPackageName());
        if (config.isGWTServiceServletDefined()) {
            buf.append(".");
            buf.append("server");
        }
        buf.append(".");
        buf.append("controller");
        return buf.toString();
    }

    protected ControllerDescFactory createControllerDescFactory(String controllerBasePackageName) {
        return new ControllerDescFactory(controllerBasePackageName, this.superclassName, this.testCaseSuperclassName, this.useView);
    }

    protected Generator createControllerGenerator(ControllerDesc controllerDesc) {
        return new ControllerGenerator(controllerDesc);
    }

    protected Generator createControllerTestCaseGenerator(ControllerDesc controllerDesc) {
        return new ControllerTestCaseGenerator(controllerDesc);
    }
}

