#! /usr/bin/perl -w
# $Id: jfadmlib.pm,v 1.2 2000/02/27 16:23:46 fuku Exp $

# JF  Berkeley DB ե뤤Ĥδؿ

package jfadmlib;

require Exporter;
@ISA       = qw(Exporter);
@EXPORT    = qw(add_ent del_ent get_ent);
@EXPORT_OK = qw(LOCK_SH LOCK_EX LOCK_NB LOCK_UN lockdb unlockdb);
%EXPORT_TAGS = (LOCKS  => [ qw(LOCK_SH LOCK_EX lockdb unlockdb) ]);

require 5.003;
use strict;
use strict 'vars';
use strict 'subs';
use strict 'refs';
use DB_File;
use Fcntl;

my $sep = "\@\@";
#
# DB  data Ǽ롣
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
# arg_3: data
#
sub add_ent {
  my ($H, $name, $kwd, $data) = @_;
  my $key = $name . $sep . $kwd;
  $H->put($key, $data);
#  $H->sync();  # Tooo sssllooww..
  return 1;
}


# DB  data 
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
#
sub del_ent {
  my ($H, $name, $kwd) = @_;
  my $key = $name . $sep . $kwd;
  $H->del($key);
#  $H->sync();  # Tooo sssllooww..
  return 1;
}

#
# DB  data 롣
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
#
# Ф줿 data  return 롣
#
sub get_ent {
  my ($H, $name, $kwd) = @_;
  my $key = $name . $sep . $kwd;
  my $var;
  $H->get($key, $var);
  if ($var) {
    return $var;
  } else {
    return 0;
  }
}


sub LOCK_SH {1}
sub LOCK_EX {2}
sub LOCK_NB {4}
sub LOCK_UN {8}

sub lockdb {
  my ($H, $L) = @_;
  my $fd = $H->fd;
  open(DB_FH, "+<&=$fd") or die;
  unless (flock (DB_FH, $L | LOCK_NB)) {
    unless (flock (DB_FH, $L)) { die }
  }
#  print STDERR "DEBUG: Locked\n" if $ENV{'TERM'};
  return 1;
}

sub unlockdb {
  flock(DB_FH, LOCK_UN);
#  print STDERR "DEBUG: UnLocked\n" if $ENV{'TERM'};
}


1;
