#! /usr/bin/perl -w
# $Id: KernelConf.pm,v 1.6 2003/03/14 11:11:40 mdk Exp $

package KernelConf;

require Exporter;
@ISA       = qw(Exporter);
@EXPORT    = qw(compare getmd5 splitconf print_item get_cnflist);
@EXPORT_OK = qw(LOCK_SH LOCK_EX LOCK_NB LOCK_UN lockdb unlockdb);
%EXPORT_TAGS = (LOCKS  => [ qw(LOCK_SH LOCK_EX lockdb unlockdb) ]);

require 5.003;
use strict;
use strict 'vars';
use strict 'subs';
use strict 'refs';
use DB_File;
use Fcntl;

sub compare {
  my ($newconfs, $md5newconf, $md5oldconf) = @_;
  my @e;
  my %stats;
  foreach my $c ( @$$newconfs ) {
    unless(defined $c){
	# ɤʥ顼åФ٤?
	next;
    }
    if (!$$md5oldconf->{$c}) {
      $stats{$c} = "N";
      $e[0]++;
    } elsif ($$md5oldconf->{$c} ne $$md5newconf->{$c}){
      $stats{$c} = "*";
      $e[1]++;
    } else {
      $stats{$c} = "-";
      $e[2]++;
    }
  }
  return (\@e, \%stats);
}

sub getmd5 {
  my ($confs, $dir, $verbose) = @_;
  my %md5hash;
  my ($i, $j);
  my $step = 36;
  my $k = @$confs;
  if ($verbose) {
    for ($j = 0; $j < $k; $j = $j + $step) {
      print ".";
    }
    for ($j = 0; $j < $k; $j = $j + $step) {
      print "[D";
    }
  }
  foreach my $c (@$confs) {
    unless(defined $c){
	# ɤʥ顼åФ٤?
	next;
    }

    $i++;
    print "o" if ($verbose) && ($i % $step == 0);

    unless(-r "$dir/$c"){
	warn "Can't open $dir/$c\n";
	next;
    }

    open(MD5, "md5sum $dir/$c |");
    while (<MD5>) {
      my @p = split;
      $md5hash{$c} = $p[0];
    }
    close MD5;
  }
  print "o" if $verbose;
  return %md5hash;
}

sub get_cnflist {
  my $file = $_[0];
  my @cnf;
  open(F, $file) or die;
  while (<F>) {
    if (/^(CONFIG|DEBUG)/) {
      chomp;
      s/\s.*$//;
      push(@cnf, $_);
    }
  }
  close F;
  return \@cnf;
}

sub splitconf {
  my ($file, $wdir) = @_;
  my $header_flag = 1;
  my $symbol_flag = 0;
  my $i = -1;
  my $q = 0;
  my @desc;
  my @conf;
  my @sd;
  mkdir($wdir,0755)  unless -d $wdir;
  open(CONFFILE, "./latin_to_ascii.sed <$file |") or die;
  open(HEADER, ">$wdir/header.txt") or die;
  while (<CONFFILE>) {
    if ($header_flag) {
      print HEADER $_;
      if (/^$/) {
	$header_flag = 0;
	close HEADER;
      }
      next;
    }

    next if /^\#/;   

    if (/^(\S.*)$/) {
      if (/^ICN EDSS Cisco/) {	# 2.4.0 - 2.4.3 illegal field
	last;
      } elsif (/^(CONFIG|DEBUG).*$/) {
	$i++ if $conf[$i];	# no title
	chomp;
	s/\s.*$//;
	$conf[$i]  = $_;
	&print_item($sd[$i-1], $conf[$i-1], \@desc, $wdir); # if $i > 0;
	$symbol_flag = 1;
	undef @desc;
      } else {
	if (($i == -1) or $conf[$i])  {
	    $sd[++$i] = $1;
	} else {		# no symbol
	    $sd[$i] = $1;
	}
	$symbol_flag = 0;
      }
    } else {
      if (/^\s*$/) {
	next if $q;
	$q = 1;
      } else {
	$q = 0;
      }
      push(@desc,$_) if $symbol_flag;
    }
  }
  &print_item($sd[$i], $conf[$i], \@desc, $wdir);
  close CONFFILE;
  return \@conf;
}


sub print_item {
  local($_);
  my ($title, $symbol, $content, $dir) = @_;

  # ȤȤ Configure.help-x.x.x ְäƤơ
  # ܥ (CONFIG_ʤȤ) ʤĤ褿ꤹ
  # ȤꤢǤϽ뤷ʤ
  #
  #  warn ФƽϤȤƤ󤸤ʤǤ (nakano)
  unless(defined $symbol){
      warn "Incomplete entry in $dir:\n  `$title' has no symbol.\n";
      return;
  }
  unless(defined $title){
      warn "Incomplete entry in $dir:\n  `$symbol' has no title.\n";
  }

  open(ITEM, "> $dir/$symbol") or die "Can't open $dir/$symbol\n";
  print ITEM "$title\n" if $title;
  print ITEM "$symbol\n" if $symbol;
  foreach (@$content) {
      print ITEM;
  }
  close ITEM;
}


sub LOCK_SH {1}
sub LOCK_EX {2}
sub LOCK_NB {4}
sub LOCK_UN {8}

sub lockdb {
  my ($H, $L) = @_;
  my $fd = $H->fd;
  open(DB_FH, "+<&=$fd") or die;
  unless (flock (DB_FH, $L | LOCK_NB)) {
    unless (flock (DB_FH, $L)) { die }
  }
#  print STDERR "DEBUG: Locked\n" if $ENV{'TERM'};
  return 1;
}

sub unlockdb {
  flock(DB_FH, LOCK_UN);
#  print STDERR "DEBUG: UnLocked\n" if $ENV{'TERM'};
}


1;
