#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
# listjfindex.pl -- Listing JF info index
# $Id: _listjfindex.pl,v 1.2 2000/02/27 16:23:46 fuku Exp $
# 
# []
# bin/genindex.pl ˤä줿 JF  info index (jfindex.db)
# Ȥɽ뤿 sample script Ǥ
#
#  script  Web ƥĤˤϻȤޤ󤬡ƥʥ
# ˤ info index Ȥǧ˻ѤǤޤ
# info index Ȥäƿ Web ƥĤ褦ȻפΩä
# ˤ⻲ͤˤƤ
# 
# script ѿ񤭴ʤ¤ꡢ script  bin 򥫥
# ǥ쥯ȥˤƼ¹Ԥ뤳ȤꤷƤޤŪ˻Ȥ
# jfadmlib.pm ⥸塼 @INC ǸǤ֤ copy Ʊˡ
# ѿ $indexfile  info index ξꤷƤ
#
# Ȥ:
#  -k string: Ф KEY Ȥ˻ꤷޤ
#             NAME, AUTH, COPY, ITEM, TRNS, KEY ʤɡinfo ǻȤƤ
#             ̾Ǥ-k option λ꤬ʤϡ٤Ƥ KEY 
#             Ϥޤ
#
#  -n string: Фʸ̾Ȥ˻ꤷޤ
#             string ʬפǡ羮ʸ̤ޤ
#             -n option λ꤬ʤϡ٤ƤʸΥǡϤޤ
#
#   option Ĥʤäϡinfo index ˵ϿƤǡ
#  ٤ƽϤ뤳Ȥˤʤޤ
#
# []
#  1. ATAPI  NAME ˤʸ info Ϥ
#     ./listjfindex.pl -n ATAPI
#
#  2. ̾ꥹȥåפ
#     ./listjfindex.pl -k TRNS
#
#  3. "3-Button-Mouse" ʸϤ
#     ./listjfindex.pl -n 3-Button-Mouse -k JDAT
#
#
#

use DB_File;
use jfadmlib;
use Getopt::Std;

my $indexfile = "../jfindex.db";

my (%hash, $key, $name, @d, $H);
getopts('hk:n:', \%opts);

if ($opts{'h'}) {
    &print_usage;
    exit;
}

$key  = $opts{'k'} if $opts{'k'};
$name = $opts{'n'} if $opts{'n'};

$H = tie(%hash, 'DB_File', $indexfile, O_RDONLY, 0644, $DB_BTREE) or die;

while (my ($k, $v) = each %hash) {
    if ($key) {
	next unless ($k =~ /\@\@$key/i);
    }
    if ($name) {
	next unless ($k =~ /$name/i);
    }
    @d = split(/\@\@/, $k);
    push(@d, $v);
    write;
}

undef $H; untie %hash;
exit;


format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
@d
.

sub print_usage {
    print <<EOUSAGE;
listjfindex.pl -- Listing JF info index.
  -k string : specify a key string.
  -n name   : specify the document name.
  -h        : print this help.

  EX.  ./listjfindex -n xfree -k trns
EOUSAGE
}

# Local variables:
# cperl-indent-level: 4
# End:
