#! /usr/bin/perl
# 
# JF  Berkeley DB եɤǡꥹȤϤ뤿
# ץȡ
# Fujiwara ν񤤤ץȤ١ˤƤ롣
#
# -d: 礹 Berkeley DB file ̾
# -t: output format type (HTML or TEXT)
# -w: jf.css 򻲾Ȥ HTML  (JF  Web Page  INDEX ϤȤ)
#

use strict 'vars';
use strict 'subs';
use strict 'refs';
use vars qw(%opts);
use DB_File;
use lib qw(bin);
use jfadmlib qw(:DEFAULT :LOCKS);
use Getopt::Std;

getopts('t:d:c:p:w', \%opts);
die    unless ($opts{'d'} || $opts{'t'});
my $database = $opts{'d'} if $opts{'d'};
my $type     = $opts{'t'} if $opts{'t'};

###############################################
# my @project = ('LILO-doc', 'LTGP');
my @project = ('LILO-doc');
my $description = {
		   'LILO-doc' => "Linux Install Learning Osaka",
		   'LTGP' => "Linux Total Guide Project",
};
###############################################

my $www = 0;
$www = 1 if $opts{'w'};  

#
# get time data
#
my @t = &get_timelist(time);


#
# tie database object to hash, and lock it.
#
my ($H, %index);
$H = tie(%index, 'DB_File', "$database", O_RDONLY, 0644, $DB_BTREE) or die;

#
# output header
#
if ($type eq "HTML") {
    &print_html_header($www);
    print "<H2><A NAME=\"JFLIST\">JF ˴£줿ɥȤΥꥹ</A></H2>\n";
} else {
    print "JF ˴£줿ɥȤΥꥹ\n\n";
}

#
# output datas.
#
foreach my $p (@project) {
    if ($type eq "HTML") {
	print "<H3><A NAME=\"$p\">$p ($description->{$p}) ʸ</A></H3>\n";
	print "<DL>\n";
    } else {
	print "\n== $p ($description->{$p}) ʸ == \n\n";
    }

    &pickup($p, \%index, $H, $type);
    print "</DL>\n" if $type eq "HTML";
}

&print_html_footer($www,\@t) if $type eq "HTML";  

#
# untie index.
#
undef $H;
untie %index;
exit;
#
# end of main procedure
#

sub pickup
{
    my ($proj, $index, $H, $type) = @_;
    foreach my $key (keys %$index) {
	next unless $key =~ /\@\@ITEM$/;
	my ($name, $dummy) = split("\@\@", $key);
	my $KIND = get_ent($H, $name, "KIND");
	next unless $KIND eq $proj;
	my $CONT = get_ent($H, $name, "CONT");
	my $JDAT = get_ent($H, $name, "JDAT");
	my $TITL = get_ent($H, $name, "TITL");
	my (@AUT, @TRN);
	$AUT[0]  = get_ent($H, $name, "AUTH");
	$AUT[1]  = get_ent($H, $name, "AUT2");
	$AUT[2]  = get_ent($H, $name, "AUT3");
	$TRN[0]  = get_ent($H, $name, "TRNS");
	$TRN[1]  = get_ent($H, $name, "TRN2");
	$TRN[2]  = get_ent($H, $name, "TRN3");
	foreach (@AUT, @TRN) {
	    s/<.*>//;
	    s/\s+$//;
	}
	$CONT    = "unrecorded" unless $CONT;
	$JDAT    = "unrecorded" unless $JDAT;
	if ($type eq "HTML") {
	    &print_html_data($name, $KIND, $CONT, $JDAT, $TITL, \@AUT, \@TRN);
	} else {
	    &print_text_data($name, $KIND, $CONT, $JDAT, $TITL, \@AUT, \@TRN);
	}
    }
}

sub print_html_data {
    my ($name, $KIND, $CONT, $JDAT, $TITL, $AUT, $TRN) = @_;
    if (-f "$KIND/$name.html") {
	print "<DT><A HREF=\"$KIND/$name.html\"><STRONG>$TITL</STRONG></A>\n";
    } else {
	print "<DT><STRONG>$TITL</STRONG>\n";
    }
    print "  <SMALL>($JDAT)</SMALL>\n";
    print "  <DD>$CONT\n      <SMALL>\n";
    print "      [<A HREF=\"$KIND/$name.txt\">ƥ</A>]\n" if (-f "$KIND/$name.txt"); 
    print "      <BR>\n";
    print "      : $AUT->[0]\n" if $AUT->[0];
    print "          , $AUT->[1]\n" if $AUT->[1];
    print "          , $AUT->[2]\n" if $AUT->[2];
    print "      : $TRN->[0]\n" if $TRN->[0];
    print "          , $TRN->[1]\n" if $TRN->[1];
    print "          , $TRN->[2]\n" if $TRN->[2];
    print "      </SMALL></DD>\n";
}


sub print_text_data {
    my ($name, $KIND, $CONT, $JDAT, $TITL, $AUT, $TRN) = @_;
    my $filename;
    if (-f "$KIND/$name.txt") {
	$filename = $name . ".txt";
    } elsif (-f "$KIND/$name.sgml") {
	$filename = $name . ".sgml";
    }

    format STDOUT =
 Filename: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< Updated: @<<<<<<<<<
           $filename,                                               $JDAT
 Title:    @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
           $TITL
 Description: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
           $CONT
.

    write if $filename;  
    print " Author:   $AUT->[0]"   if $AUT->[0];
    print ", $AUT->[1]"            if $AUT->[1];
    print ", $AUT->[2]"            if $AUT->[2];
    print "\n"                     if $AUT->[0];
    print " Translator: $TRN->[0]" if $TRN->[0];
    print ", $TRN->[1]"            if $TRN->[1];
    print ", $TRN->[2]"            if $TRN->[2];
    print "\n"                     if $TRN->[0];
    print "\n";

}


sub print_html_header {
    my $www = $_[0];
print <<"-HEADER-ONE-";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
  "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja" dir="ltr">
<head>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <title>JF-INDEX:  Project δ£ʸ</title>
 <meta name="author" lang="en" content="JF Project Members">
 <meta name="copyright" content="(C) 1998-2015 JF Project.">
 <meta name="description" content="Linux ˴ؤʸFAQ ʤɤۤ JF Project ʸǤ">
 <meta name="keywords" content="JF,Linux,Japanese,ʸ,ɥ,,HOWTO,FAQ">
 <link rev="made" href="mailto:jf\@listserv.linux.or.jp">
-HEADER-ONE-

  print " <LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../jf.css\">\n"
    if $www;

print <<"-HEADER-TWO-";
</HEAD>

<body>

-HEADER-TWO-

    if ($www) {
	print "<h1><a href=\"../index.html\">JF</a>: Index</h1>";
    } else {
	print "<h1>JF-INDEX</h1>";
    }

}

sub print_html_footer {
    my ($www, $t) = @_;
    print <<"-FOOTER-ONE-";
<HR>
 <ADDRESS>
  JF Project ̤˴ؤ뤴ո˾
  jf\@listserv.linux.or.jp ޤǤͤޤ
 </ADDRESS>
-FOOTER-ONE-

    print <<"-FOOTER-WWW-" if $www;
 <DIV CLASS="copyright">
  <A HREF="../index.html">JF Project ᥤڡ</A></BR>
 </DIV>
-FOOTER-WWW-
  
 print " <DIV CLASS=\"copyright\">\n" if $www;
 print "ꥹȹ: $t->[0]/$t->[1]/$t->[2] $t->[4]:$t->[5]:$t->[6]<BR>\n";
 print " </DIV>\n" if $www;
 print "\n</BODY>\n</HTML>\n";
 return 1;
}

sub get_timelist() {
  my ($sec,$min,$hour,$day,$month,$year,$wday,$yday,$isdst) = localtime($_[0]);
  my @dow = ("Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat");
  my $dow = $dow[$wday];
  $month = $month + 1;
  $month = 1 if $month == 13;
  $month = "0" . $month if $month < 10;
  $day   = "0" . $day   if $day   < 10;
  $hour  = "0" . $hour  if $hour  < 10;
  $min   = "0" . $min   if $min   < 10;
  $sec   = "0" . $sec   if $sec   < 10;
  $year += 1900;
  return ($year, $month, $day, $dow, $hour, $min, $sec);
}
# Local variables:
# cperl-indent-level: 4
# End:
