#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# chdiff.pl -- for  tool
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# $Id: chdiff.pl,v 1.1 2001/07/02 16:47:55 gotom Exp $
# 
# Ȥ
#
#    % ./chdiff.pl CONFIG_FXIMA      (wdiff Ȥäɽ)
#    % ./chdiff.pl -d CONFIG_FXIMA   (diff Ȥäɽ)
#

use strict;
use Getopt::Std;
use vars qw(%opts);
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

getopts('d', \%opts);

unless ($ARGV[0]) {
  print <<"USAGE";
chdiff.pl [-d] CONFIG_NAME
  Option: -d ... use "diff -u" as diff (default: wdiff)
  Example: ./chdiff.pl CONFIG_EXPERIMENTAL
USAGE
exit 1;
}

my @configure = (glob "Configure.help-2.4.? Configure.help-2.4.??");
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];
my $cnf_item  = $ARGV[0];
my $CONFPrefix = "CONFIG-Configure.help-";
my $diff = "wdiff";

if ($opts{'d'} || system("which wdiff>& /dev/null")) {
  $diff =  "diff -u";
}

my $j;
my @HT;
for ($j = 0; $j < $num_files; $j++) {
  tie(%{$HT[$j]}, 'DB_File', "Mod_$configure[$j].db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$configure[$j].db";
}

my $cnf = get_cnflist($latest);
my $C = {};
foreach my $key (@$cnf) {

  my $last_flag = "";
  my $point = 0;
  my @e;

  for ($j = 0; $j < $num_files; $j++) {
    my $e  = " ";
    $e = $HT[$j]{$key} if $HT[$j]{$key};
    push(@e, $e);
  }
  $C->{$key}->{"stat"} = \@e;
}

my @vers;
foreach (@configure) {
  if (/.*\-(.*)/) {
    push(@vers, $1);
  }
}

my $key = $cnf_item;
my $l = 0;
foreach my $q (@{$C->{$key}->{"stat"}}) {
  if ($q eq "N") {
    print "==> $key : $vers[$l] (New Item)\n";
    &cat("$CONFPrefix$vers[$l]/$key");
  } elsif ($q eq "*") {
    print "==> $key : $diff $vers[$l-1] $vers[$l]\n";
   &getdiff($diff, "$CONFPrefix$vers[$l-1]/$key", "$CONFPrefix$vers[$l]/$key");
  }
  $l++;
}

sub cat {
  my $file = $_[0];
  open (F, $file) or die;
  print while <F>;
  close F;
}

sub getdiff {
  my ($diff, $o, $n) = @_;
  open (F, "$diff $o $n | ") or die;
  print while <F>;
  close F;
}
