#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# cleanup.pl -- commit κݤˤޤˤʤ copy item 
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# $Id: cleanup.pl,v 1.1 2001/07/02 16:47:55 gotom Exp $
# 

use strict;
use Getopt::Std;
use vars qw(%opts);
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

getopts('n', \%opts);

my @configure = (@ARGV);
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];

foreach my $p (@configure) {
  my %H;
  tie(%H, 'DB_File', "Mod_$p.db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$p.db";
  my $cnf = get_cnflist($p);

  foreach my $key (@$cnf) {
    my $e  = " ";
    $e = $H{$key} if $H{$key};
    
    if ($e eq "-") {
      if ( -r "TRANS-$p/$key" ) {
	if ($opts{'n'}) {
	  print "TRANS-$p/$key\n";
	} else {
#	  print "deleting TRANS-$p/$key...\n";
	  unlink "TRANS-$p/$key";
	}
      }
    }
  }
  untie %H;
}

