#! /usr/bin/perl
package jfenq;
use DB_File;
use Fcntl;

my $sep = "\@\@=";
my $result_uri = "http://amorph.net/fxima/JF/enq/result.cgi";
my $submit_uri = "enquete-01.html";

# DB  data Ǽ롣
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
# arg_3: data
#
sub add_ent {
  my ($H, $name, $data) = @_;
  $H->put($name, $data);
  $H->sync();
  return 1;
}

# DB  data 
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
#
sub del_ent {
  my ($H, $name, $kwd) = @_;
  my $key = $name . $sep . $kwd;
  $H->del($key);
  $H->sync();
  return 1;
}
# DB  data 롣
#
# arg_0: Berkeley BD  hash  tie  return ͡
# arg_1: NAME / hash  key ΰˤʤ롣
# arg_2: Keyword / hash  key ΰˤʤ롣
#
# Ф줿 data  return 롣
#
sub get_ent {
  my ($H, $name, $kwd) = @_;
  my $key = $name . $sep . $kwd;
  my $var;
  $H->get($key, $var);
  if ($var) {
    return $var;
  } else {
    return 0;
  }
}

sub LOCK_SH {1}
sub LOCK_EX {2}
sub LOCK_NB {4}
sub LOCK_UN {8}

sub lockdb {
  my ($H, $L) = @_;
  my $fd = $H->fd;
  open(DB_FH, "+<&=$fd") or die;
  unless (flock (DB_FH, $L | LOCK_NB)) {
    unless (flock (DB_FH, $L)) { die }
  }
  return 1;
}

sub unlockdb {
  flock(DB_FH, LOCK_UN);
}

# 󥱡Ȥβ򽸷פޤ
sub summarize_enq {
  my ($enq, $chkbox_item, $in) = @_;
  my $ans = {};
  my $chkbox = {};
  my $i;
  for ($i = 1; $i < $enq; $i++ ) {
    my $Q = "Q-" . $i;
    if ($chkbox_item->[$i]->[1]) {
      $ans->{$Q} = "checkbox";
      my $j = 1;
      foreach (@{$chkbox_item->[$i]}) {
	$chkbox->{$Q}->[$j] = $in->{"$Q.$j"} if $in->{"$Q.$j"};
	$j++;
      }
    }else {
      $ans->{$Q} = $in->{$Q};
    }
  }
  my $email = $in->{'email'};
     $email =~ s/+//g;
     $email =~ s/^\s+//g;
     $email =~ s/\s+$//g;
     $email =~ s/<+//g;
     $email =~ s/>+//g;
  my $name  = $in->{'name'};
     $name =~ s/+/ /g;
     $name =~ s/\s+/ /g;
     $name =~ s/^\s+//g;
     $name =~ s/\s+$//g;
     $name =~ s/</&lt\;/g;
     $name =~ s/>/&gt\;/g;

  return($ans, $chkbox, $email, $name);
}

# 졢debug ѤʤΤǤĤޤ.
sub print_debug_message {
  my ($enq, $question, $radio_item, $chkbox_item, $texts_item, $textarea, $in)
    = @_;
  my $i;
  print "<PRE>\n";
  for ($i = 1; $i <= $enq; $i++ ) {
    my $Q = "Q-" . $i;
    print "$Q $question->[$i]\n";
    my $j = 0;
    foreach my $p (@{$radio_item->[$i]}) {
      $j++;
      print "   ANS: $j: $p\n" if $in->{"$Q"} eq "$j";
    }
    $j = 0;
    foreach my $p (@{$chkbox_item->[$i]}) {
      $j++;
      print "   ANS: $j: $p\n" if $in->{"$Q.$j"} eq "on";
    }
    if ($textarea->[$i]) {
      print "   ANS: $in->{$Q}\n";
    }
  }
  print "   email: $in->{'email'}\n";
  print "   name:  $in->{'name'}\n";
  print "</PRE>\n";
}

# 󥱡ȤμƤꥹȲޤ.
sub get_lo_enq {
  my $basefile = $_[0];
  my ($enq, $radio, $chkbox, $texts) = (0, 0, 0, 0);
  my $question = [];
  my $radio_item = [];
  my $chkbox_item = [];
  my $texts_item = [];
  my $textarea = [];
  open(F, "m4 -P -D_INDEXING=1 -D_LINK=\\\$2  $basefile |" ) or die;
  while (<F>) {
    next if /^m4_dnl/;
    next if /^\s*$/;
    chomp;
    s/\)\s*$//;
    if (/^_ENQ\((.*)$/) {
      $enq++;
      $radio = 1;
      $chkbox = 1;
      $texts = 1;
      $question->[$enq] .= $1;
      next;
    } elsif (/^_RADIO\((.*)$/) {
      $radio_item->[$enq]->[$radio++] = $1;
    } elsif (/^_CHKBOX\((.*)$/) {
      $chkbox_item->[$enq]->[$chkbox++] = $1;
    } elsif (/^_TEXTS\((.*),(.*)$/) {
      $texts_item->[$enq]->[$texts++] = $1;
    } elsif (/^_TEXTAREA/) {
      $textarea->[$enq] = 1;
    } else {
      $question->[$enq] .= $_;
    }
  }
  close F;

  return ($enq, $question, $radio_item, $chkbox_item, $texts_item, $textarea);
}

# email address ̵ʤ 0 ֤
sub chk_email {
  my $email = $_[0];
  return 0 
    if $email =~ /^(nobody|postmaster|guest|MAILER-DAEMON|anonumous)\@/i;
  if ($email =~ /^\s*<*[a-zA-Z\.\-\+\|_0-9%\'\/]+\@\[*[a-zA-Z\.\-\+\|_0-9]+\.[a-zA-Z\.\-\+\|_0-9]+\]*>*\s*$/i) {
    return 1;
  } else {
    return 0;
  }
}

# 󥱡ȷ̤ХååפΤ mail ؿ.
sub sendmail {
  my ($version, $email, $val, $addr) = @_;
  open(M, "| /usr/sbin/sendmail $addr") or die;
  jcode::convert(\$val, 'jis');
  print M <<"EOMAIL";
From: jfenq\@amorph.net
Subject: [JF-ENQ $version] $email
X-JF-ENQ-Line: $version $email

VALUE: <$email> $val

EOMAIL
  close M;
}

sub print_html_header {
  my $title = $_[0];
print <<"HEADER";
Content-Type: text/html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
  "http://www.w3.org/TR/REC-html40/loose.dtd">
<HTML><HEAD>
<TITLE>Linux JF Project: $title</TITLE>
 <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=EUC-JP">
 <META NAME="DESCRIPTION" CONTENT="JF Project enquete">
 <META NAME="AUTHOR"      CONTENT="JF Project Members">
 <META NAME="KEYWORDS"    CONTENT="JF,Linux,Japanese,HOWTO,FAQ">
 <META NAME="ROBOTS"      CONTENT="NOINDEX,NOFOLLOW">
 <LINK REV="MADE"         HREF="mailto:JF\@linux.or.jp">
 <STYLE TYPE="text/css">
<!--
body {
	background-color: #ffe;
}
a:link    { color: #44f; }
a:visited { color: #72f; }
a:active  { color: #f33; }

table tr.odd,table tr.dark {
	background-color: #f0f0e0;
	vertical-align: top;
}

table tr.even {
	background-color: #f8f8e4;
	vertical-align: top;
}

div.mirror {
	background-color: #ddc;
	text-align: right;
	font-size: smaller;
	font-family: helvetica, sans-serif;
}
div.copyright {
	background-color: #ddc;
	text-align: right;
	font-size: smaller;
	font-family: helvetica, sans-serif;
}
div.rcsid {
	background-color: #ddc;
	text-align: right;
	font-size: smaller;
	font-family: helvetica, sans-serif;
}

span.new {
	font-family: helvetica, sans-serif;
	font-weight: bold;
	color: #d33;
}
span.updated {
	font-family: helvetica, sans-serif;
	font-weight: bold;
	color: #3a5;
}

h1 {
	font-family: helvetica, sans-serif;
	font-size: 220%;
	border-style: inset;
	border-width: 0 0 3 0;
	border-color: #000;
}
span.stitle{
	font-size: 18pt;
}
span.h2small{
	font-family: helvetica, sans-serif;
	font-style: italic;
	font-size: 12pt;
}
h2 {
	background-color: #ddc;
	color: #210;
	border-style: inset;
	border-width: 0 2 2 0;
	border-color: #000;
}
h3 {
	border-style: inset;
	border-width: 0 0 1 0;
	border-color: #aa9;
}
pre {
	background-color: #fff;
	padding: 0.3em;
	border: 1px inset #885;
	white-space: pre; /* Netscape 4.x needs it */
}

DIV.footer {
	color: #606060;
	font-size: 70%;
}
-->
</STYLE>
</HEAD><BODY>
HEADER
}

sub print_html_footer {
print <<'FOOTER';
<DIV CLASS="footer">
JF Project ̤˴ؤ뤴ո˾ JF@linux.or.jp ޤǤꤤޤ.
<BR>
<A HREF="http://www.linux.or.jp/JF/">[JF Project Top Page]</A>
</DIV>
FOOTER
print "</BODY></HTML>\n";
}

sub print_toc {
  my ($val, $split_num, $start_num, $datanum, $headflag) = @_;
      $split_num = 3 unless $split_num;
      $start_num = 0 unless $start_num;

  my ($chk_one, $chk_two, $chk_thr, $chk_fou, $chk_fiv);
  if ($val) {
    $chk_one = "checked" if $val == 1;
    $chk_two = "checked" if $val == 2;
    $chk_thr = "checked" if $val == 3;
    $chk_fou = "checked" if $val == 4;
    $chk_fiv = "checked" if $val == 5;
  } else {
    $chk_one = "checked";
  }

  if ($headflag){
    if ($start_num < $datanum) {
      print <<"HEADFLAG";
<FORM METHOD=POST ACTION="$result_uri">
    <INPUT TYPE="hidden" NAME="format" VALUE="3">
    <INPUT TYPE="hidden" NAME="start" VALUE="$start_num">
    <INPUT TYPE="hidden" NAME="datanum" VALUE="$datanum">
<INPUT TYPE="text" NAME="split" SIZE="3" MAXLENGTH="4" VALUE="$split_num">
    ʬꥹƥɽ<INPUT TYPE="submit" VALUE="Sumbit"><BR>
</FORM>
HEADFLAG
    }
    return 3;
  }

  if ($val == 3) {
    print <<"NEXT";
<HR>
<FORM METHOD=POST ACTION="$result_uri">
    <INPUT TYPE="radio" NAME="format" VALUE="3" checked>
    <INPUT TYPE="text" NAME="split" SIZE="3" MAXLENGTH="4" VALUE="$split_num">
    <INPUT TYPE="hidden" NAME="start" VALUE="$start_num">
    ʬꥹƥɽ <INPUT TYPE="submit" VALUE="Sumbit"><BR>
    <INPUT TYPE="hidden" NAME="datanum" VALUE="$datanum">
    <INPUT TYPE="radio" NAME="format" VALUE="1">ޥ꡼<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="2">ꥹƥ<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="4">ȤΤɽ<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="5">԰<BR>
</FORM>
<A HREF="$submit_uri">Ͽ̤ˤɤ</A>
NEXT
  } else {
    print <<"TOC";
<H2>󥱡ȷ ɽˡ</H2>
<P>
<FORM METHOD=POST ACTION="$result_uri">
    <INPUT TYPE="radio" NAME="format" VALUE="1" $chk_one>ޥ꡼<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="2" $chk_two>򤹤٤ƥꥹƥɽ<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="3" $chk_thr>
    <INPUT TYPE="text" NAME="split" SIZE="3" MAXLENGTH="4" VALUE="$split_num">
    <INPUT TYPE="hidden" NAME="start" VALUE="0">鷺 ʬꥹƥɽ<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="4" $chk_fou>ȤΤɽ<BR>
    <INPUT TYPE="radio" NAME="format" VALUE="5" $chk_fiv>԰<BR>
    <INPUT TYPE="hidden" NAME="datanum" VALUE="$datanum">
<INPUT TYPE="submit" VALUE="Sumbit">
</FORM>
<A HREF="$submit_uri">Ͽ̤ˤɤ</A>
TOC
  }
}

sub print_error {
  my ($error, $opt) = @_;
  print_html_header("Error: $error");
  print "<H2>Error: $error</H2>\n<P>";
 SWITCH: {
    if ($error eq "nomail") {
      print "email ɥ쥹Ƥޤ\n";
      last SWITCH;
    }
    if ($error eq "invalid_email") {
      print "email ɥ쥹ʸȤƤ뤫";
      print "ĿͻŪŬä email ɥ쥹ǤϤʤ褦Ǥ:\n";
      print "<UL><LI>email: $opt</LI></UL>\n";
      print "ٳǧƤߤƤ\n";
      last SWITCH;
    }
    if ($error eq "noname") {
      print "̾Ƥޤ\n";
      last SWITCH;
    }
    if ($error eq "noanswer") {
      print "Ƥʤܤޤ\n";
      last SWITCH;
    }
  }
   print "β̤äơƵ򤪴ꤤޤ</P>\n";
  print_html_footer;
  exit;
}

1;
