#pragma once

#define ARRAY_SIZE(x)	(sizeof(x)/sizeof((x)[0]))

namespace GenericUtility {

	/**
	 * W[fBNg擾.
	 */
	std::wstring GetModuleDir();

	/**
	 * ݒt@CpX擾.
	 *iW[fBNg̒̎wt@C̃t@Cj
	 */
	std::wstring GetStorageFilename(const std::wstring& strFilename);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * 񃊃\[X擾.
	 */
	CString LoadStringRes(UINT uID);

	/**
	 * Zp[^ŋ؂ĘA.
	 */
	CString ConcatenateStrings(const std::vector<CString>& strings, const CString& sep);

	/**
	 * Lȃt@CpXǂ擾.
	 */
	bool IsValidFilePath(LPCTSTR lpszFilePath);
	/**
	 * ׂĂLȃt@CpXǂ擾.
	 */
	bool AreValidFilePaths(const std::vector<CString>& filePaths);

	/**
	 * L[Ă邩ǂ擾.
	 */
	bool IsKeyPressed(int nVertKey);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * XĝׂĂ̍ڂI.
	 */
	void ListCtrl_SelectAllItems(CListCtrl& list);

	/**
	 * XĝׂĂ̑I.
	 */
	void ListCtrl_UnselectAllItems(CListCtrl& list);

	/**
	 * XgőIĂŏ̃ACe擾.
	 */
	int ListCtrl_GetSelectedItem(const CListCtrl& list);
	/**
	 * XgőIĂ邷ׂẴACe擾.
	 */
	std::vector<int> ListCtrl_GetAllSelectedItems(const CListCtrl& list);

	/**
	 * Xg̑IĂŏ̍ڂҏW.
	 * IĂȂ΁AȂ.
	 */
	void ListCtrl_EditSelectedLabel(CListCtrl& list);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * RXgN^ Redraw ~AfXgN^ōĊJ.
	 * XgRg[ύXƂȂǂɎgp.
	 * EBhEɑ΂ďd˂Ďgpꍇ́AԊÔ̂LɂȂ.
	 */
	class CSuspendRedraw
	{
	public:
		/**
		 * RXgN^
		 * @param[in] bRedrawOnEnd I RedrawWindow() s邩ǂ
		 *            (CListCtrl ł͂ȂĂ\Ȃ悤ACMFCPropertyGridCtrl Ȃǂł͕Kv)
		 */
		CSuspendRedraw(CWnd* pWnd, bool bRedrawOnEnd = false);
		~CSuspendRedraw();

	private:
		CWnd* m_pWnd;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 *  COM .
	 * operator& Ŏ擾āAfXgN^ŉ.
	 */
	template <typename T>
	class CAutoCoTaskMem
	{
	public:
		CAutoCoTaskMem() : m_pMem(NULL)
		{
		}
		~CAutoCoTaskMem()
		{
			Release();
		}

		void Release()
		{
			if (m_pMem) {
				::CoTaskMemFree(m_pMem);
				m_pMem = NULL;
			}
		}

		T** operator&()
		{
			// HACK: 擾 (Ll) Ƃz肵Ă
			// HACK: łɏLĂ΁AȂ΂ȂȂ
			ASSERT(!m_pMem);
			Release();
			return &m_pMem;
		}

		operator T*()
		{
			return m_pMem;
		}

	private:
		T* m_pMem;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * OS o[W.
	 */
	class COSVersion
	{
	public:
		/**
		 * VOgCX^X擾.
		 */
		static const COSVersion& Instance();

	public:
		COSVersion();

		/**
		 * OS ^Cv.
		 */
		enum OSType {
			OST_Unknown,

			OST_95,
			OST_98,
			OST_Me,

			OST_NT,
			OST_2k,
			OST_XP,
			OST_2003,
			OST_Vista,
			OST_7,

			OST_Latest = OST_7,
		};

		/**
		 * OS ^Cv擾.
		 */
		OSType GetOSType() const;

	private:
		/**
		 * NT t@~[ǂ𒲂ׂ.
		 */
		bool IsNTFamily() const;

		/**
		 * OS o[Ww肵o[Wȏォǂ𒲂ׂ.
		 */
		bool CheckVersion(DWORD nMajor, DWORD nMinor) const;

	private:
		/// OS o[W
		OSVERSIONINFO m_vi;
	};

}	// namespace GenericUtility
