#pragma once

#include "../ListPasteLib/DataManager.h"

/**
 * ListPaste hLg.
 */
class CListPasteDoc
{
public:
	CListPasteDoc();
	~CListPasteDoc();

	/**
	 * XgRg[C^[tF[X.
	 */
	interface IList
	{
		virtual UINT GetSelectedCount() const = 0;
		virtual POSITION GetFirstSelectedItemPosition() const = 0;
		virtual int GetNextSelectedItem(POSITION& pos) const = 0;
	};

	/**
	 * .
	 */
	void Initialize(IList* list, CWnd* pWnd);

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * f[^O[v擾.
	 */
	size_t GetGroupCount() const;

	/**
	 * ݂̃f[^O[vݒ肷.
	 */
	bool SetCurrentGroup(size_t index);
	/**
	 * ݂̃f[^O[v擾.
	 */
	size_t GetCurrentGroupIndex() const;

	/**
	 * index Ԗڂ̃f[^O[v擾.
	 */
	CString GetGroupName(size_t index);
	/**
	 * index Ԗڂ̃f[^O[vݒ肷.
	 */
	bool SetGroupName(size_t index, const CString& strName);

	typedef std::vector<size_t> IndexVec;
	/**
	 * O[vwʒuɒǉ.
	 * @param[in] index ǉʒu (~0 : )
	 */
	bool AddGroup(size_t index, const CString& strName);
	/**
	 * ̃O[vړ.
	 */
	bool MoveGroups(const IndexVec& indices, INT_PTR move);
	/**
	 * index Ԗڂ̃O[v폜.
	 */
	bool DeleteGroup(size_t index);

private:
	/**
	 * ݂̃f[^O[v擾.
	 */
	const ListPasteLib::CDataGroup& GetCurrentGroup() const;
	/**
	 * ݂̃f[^O[v擾.
	 */
	ListPasteLib::CDataGroup& GetCurrentGroup();

	/**
	 * w肵O̍ŏ̃O[v擾.
	 * ȂΒǉ.
	 */
	ListPasteLib::CDataGroup& FindOrCreateGroupByName(const CString& strName);

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * ătB^O.
	 */
	void Search();
	/**
	 * tB^OʁA擾.
	 */
	size_t GetSearchedCount() const;

	/**
	 * eLXg擾.
	 * @param[in] item Xg̃CfbNX.
	 */
	const std::wstring& GetText(int item) const;
	/**
	 * eLXgύX.
	 * @param[in] item Xg̃CfbNX.
	 */
	bool Modify(int item, const std::wstring& text);

	/**
	 * IĂACe擾.
	 */
	UINT GetSelectedCount() const;

	/**
	 * ݂̃Xg̑IԂɏ]āARs[.
	 * (XgNbv{[hւ̃Rs[)
	 */
	void Copy();
	/**
	 * ݂̃Xg̑IԂɏ]āAy[Xg.
	 * (Nbv{[h烊Xgւ̃Rs[)
	 */
	bool Paste();
	/**
	 * ݂̃Xg̑IԂɏ]āA폜.
	 */
	void Delete();
	/**
	 * Nbv{[h̓eXgɃRs[.
	 * (Paste() ɎĂ邪ANbv{[hĎ̓ꏈs)
	 */
	bool PasteOnDrawClipboard();

	/**
	 * obNAbv ID.
	 */
	enum EBackUpID
	{
		/// Undo p
		BU_Undo,
		/// XibvVbgp
		BU_Snapshot,

		BU_Size,
	};
	/**
	 * ݂ Data Manager ̃obNAbv.
	 */
	void BackUp(EBackUpID id = BU_Undo);
	/**
	 * obNAbvNA.
	 */
	void ClearBackUp(EBackUpID id = BU_Undo);
	/**
	 * obNAbvւ.
	 */
	void SwapBackUp(EBackUpID id1 = BU_Undo, EBackUpID id2 = BU_Snapshot);
	/**
	 * Data Manager  Undo  (obNAbvƓւ).
	 *  Undo obt@͈Ȃ̂ŁARedo ͕sv (x Undo  Redo).
	 */
	bool Undo(EBackUpID id = BU_Undo);
	/**
	 * Undo ł邩ǂ擾.
	 */
	bool CanUndo(EBackUpID id = BU_Undo) const;

	/**
	 * XgőIĂ邷ׂẴeLXg擾.
	 */
	std::vector<CString> GetSelectedTextVec() const;
#if 0
	/**
	 * XgőIĂ邷ׂẴeLXg擾.
	 * IĂAsŋ؂.
	 */
	CString GetSelectedTexts() const;
#endif

	/**
	 * ݂̃f[^O[ṽeLXg擾.
	 */
	const ListPasteLib::CDataGroup::WStrings& GetCurrentTexts() const;

	////////////////////////////////////////////////////////////////////////////////
private:
	/**
	 * XgőIĂŏ̃ACe擾.
	 */
	int GetSelectedItem() const;

	/**
	 * Xg̃CfbNXAm_dataManager ɂCfbNXɕϊ.
	 * @return ŶȂ ~0
	 */
	size_t Item2DataIndex(int item) const;
	/**
	 * XgőIĂŏ̃ACéAm_dataManager ɂCfbNX擾.
	 * @return IĂȂ ~0
	 */
	size_t GetSelectedDataIndex() const;
	/**
	 * XgőIĂ邷ׂẴACéAm_dataManager ɂCfbNX擾.
	 */
	ListPasteLib::CDataGroup::IndexVec GetAllSelectedDataIndices() const;

	/**
	 * Nbv{[h̃eLXgAsŕĎ擾.
	 * @param[in] maxTexts 擾ős (0: wȂ)
	 * @param[in] retry    gC (0: gCȂ)
	 */
	std::vector<std::wstring> GetTextsFromClipboard(size_t maxTexts = 0, size_t retry = 0);

private:
	/// XgRg[C^[tF[X
	IList* m_list;
	/// Nbv{[hANZXpEBhE
	CWnd* m_pWnd;

	/// f[^}l[W
	ListPasteLib::CDataManagerPtr m_dataManager;
	/// f[^}l[W (obNAbv)
	ListPasteLib::CDataManagerPtr m_dataManagerBak[BU_Size];
	/// ׂĕ\邩ǂ
	bool m_bShowAll;
	/// \Ώۃf[^CfbNX
	ListPasteLib::CDataGroup::IndexVec m_dataIndices;

	////////////////////////////////////////////////////////////////////////////////
public:
	/**
	 * Data Manager ̓e.
	 * @param[in] force ύXȂĂ
	 */
	bool Save(bool force);
	/**
	 * Data Manager ̓eǂݍ.
	 */
	bool Load();
};
