/**
 * @file  DialogPositionSaver.cpp
 * @brief _CAOʒuۑ/NX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"
#include "DialogPositionSaver.h"
#include "MiscUtil.h"

namespace DialogUtility {

namespace {

	/**
	 * ̃TCYɖ߂Ƃ̃EBhEʒu擾.
	 * @param[out] flags   ŏ\̃tO
	 * @param[out] showCmd EBhE̕\
	 */
	CRect GetWindowNormalPlacement(const CWnd* pWnd, UINT& flags, UINT& showCmd)
	{
		if (!pWnd) {
			flags   = 0;
			showCmd = SW_SHOWNORMAL;
			return CRect(0, 0, 0, 0);
		}

		WINDOWPLACEMENT wndpl;
		pWnd->GetWindowPlacement(&wndpl);
		flags   = wndpl.flags;
		showCmd = wndpl.showCmd;
		return wndpl.rcNormalPosition;
	}

	/**
	 * ̃TCYɖ߂Ƃ̃EBhEʒuݒ肷.
	 * @param[in] flags   ŏ\̃tO
	 * @param[in] showCmd EBhE̕\
	 */
	bool SetWindowNormalPlacement(CWnd* pWnd, CRect rect, UINT flags, UINT showCmd)
	{
		if (!pWnd) {
			return false;
		}
		if (rect.IsRectEmpty() && showCmd == SW_SHOWNORMAL) {
			return false;
		}

		WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
		wndpl.flags            = flags;
		wndpl.showCmd          = showCmd;
		wndpl.rcNormalPosition = rect;
		return pWnd->SetWindowPlacement(&wndpl) == TRUE;
	}

	/**
	 * ŏ\̃tOALȂ̂ɐ.
	 */
	void VerifyFlags(UINT& flags)
	{
		// HACK: WPF_RESTORETOMAXIMIZED ̂
		flags &= WPF_RESTORETOMAXIMIZED;
	}

	/**
	 * EBhE̕\ԂALȂ̂ɐ.
	 */
	void VerifyShowCmd(UINT& showCmd)
	{
		// HACK: SW_SHOWNORMAL/SW_SHOWMAXIMIZED/SW_SHOWMINIMIZED ȊO SW_SHOWNORMAL Ƃ݂Ȃ
		switch (showCmd) {
			case SW_SHOWNORMAL:
			case SW_SHOWMINIMIZED:
			case SW_SHOWMAXIMIZED:
				break;
			default:
				showCmd = SW_SHOWNORMAL;
				break;
		}
	}

}   // anonymous namespace

/////////////////////////////////////////////////////////////////////////////

CDialogPositionSaver::CDialogPositionSaver()
	: m_rc(CRect(0, 0, 0, 0))
	, m_flags(0)
	, m_showCmd(SW_SHOWNORMAL)
{
}

bool CDialogPositionSaver::Save(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}
	// _CAOʒu擾
	m_rc = GetWindowNormalPlacement(pWnd, m_flags, m_showCmd);
	// tOނmF
	VerifyFlags(m_flags);
	VerifyShowCmd(m_showCmd);
	return true;
}

bool CDialogPositionSaver::Restore(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}
	// tOނmF
	VerifyFlags(m_flags);
	VerifyShowCmd(m_showCmd);
	// _CAOʒuݒ肷
	return SetWindowNormalPlacement(pWnd, m_rc, m_flags, m_showCmd);
}

void CDialogPositionSaver::Reset()
{
	m_rc.SetRect(0, 0, 0, 0);
	m_flags   = 0;
	m_showCmd = SW_SHOWNORMAL;
}

bool CDialogPositionSaver::IsValid() const
{
	return !m_rc.IsRectEmpty();
}

const CRect& CDialogPositionSaver::GetRect() const
{
	return m_rc;
}

UINT CDialogPositionSaver::GetShowCmd() const
{
	return m_showCmd;
}

/////////////////////////////////////////////////////////////////////////////

bool CListColumnWidthSaver::Save(CListCtrl* pList)
{
	if (!pList) {
		return false;
	}
	int nCount = pList->GetHeaderCtrl()->GetItemCount();
	m_Widths.clear();
	m_Widths.reserve(nCount);
	for (int i = 0; i < nCount; ++i) {
		m_Widths.push_back(pList->GetColumnWidth(i));
	}
	return true;
}

bool CListColumnWidthSaver::Restore(CListCtrl* pList)
{
	if (!pList) {
		return false;
	}
	int nCount = pList->GetHeaderCtrl()->GetItemCount();
	if (nCount != m_Widths.size()) {
		return false;
	}

	GenericUtility::CSuspendRedraw sr(pList);
	for (int i = 0; i < nCount; ++i) {
		pList->SetColumnWidth(i, m_Widths[i]);
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////

CWndFontSaver::CWndFontSaver() : m_height(0)
{
}

bool CWndFontSaver::Save(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}

	CFont* pFont = pWnd->GetFont();
	if (!pFont) {
		return false;
	}

	LOGFONT logfont;
	if (!pFont->GetLogFont(&logfont)) {
		return false;
	}

	m_height = logfont.lfHeight;

	return true;
}

bool CWndFontSaver::Restore(CWnd* pWnd)
{
	if (!pWnd) {
		return false;
	}

	CFont* pFont = pWnd->GetFont();
	if (!pFont) {
		return false;
	}

	LOGFONT logfont;
	if (!pFont->GetLogFont(&logfont)) {
		return false;
	}

	if (logfont.lfHeight == m_height) {
		return true;
	}

	logfont.lfHeight = m_height;
	logfont.lfWidth = 0;

	CFont* pNewFont = new CFont;
	if (!pNewFont) {
		return false;
	}
	if (!pNewFont->CreateFontIndirect(&logfont)) {
		return false;
	}

	pWnd->SetFont(pNewFont);

	return true;
}

}	// namespace DialogUtility
