/**
 * @file  DragDrop.h
 * @brief OLE Drag & Drop NX`.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#pragma once

namespace GenericUtility {

	/**
	 * OLE Drag & Drop s.
	 * @note AfxOleInit() ĂłKv.
	 */
	class CDragDrop
	{
	public:
		/**
		 * hbOf[^ǉC^[tF[X.
		 */
		interface IAddDragData
		{
		public:
			/**
			 * rbg}bvf[^ǉ.
			 * @note bitmap  Detach() .
			 */
			virtual bool AddBitmap(CBitmap& bitmap) = 0;
			/**
			 * eLXgf[^ǉ.
			 */
			virtual bool AddText(LPCTSTR lpszText) = 0;
			/**
			 * t@Cǉ.
			 */
			virtual bool AddFiles(const std::vector<CString>& fileNames) = 0;
		};
		/// hbOf[^ǉ֐
		typedef boost::function<bool (IAddDragData*)> AddDragDataFunc;

		/**
		 * f[^hbO.
		 * (瑤 DataSource ɂȂ)
		 */
		static bool DragData(const AddDragDataFunc& func);

		////////////////////////////////////////////////////////////////////////////////

		/**
		 * rbg}bvf[^hbO.
		 * @note bitmap  Detach() .
		 * (瑤 DataSource ɂȂ)
		 */
		static bool DragBitmap(CBitmap& bitmap);

		/**
		 * eLXgf[^hbO.
		 * (瑤 DataSource ɂȂ)
		 */
		static bool DragText(LPCTSTR lpszText);

		/**
		 * t@ChbO.
		 * (瑤 DataSource ɂȂ)
		 */
		static bool DragFiles(const std::vector<CString>& fileNames);
	};

}	// namespace GenericUtility
