// Customize_File.cpp cCve[Vt@C
#include "Customize_File.h"


////////////////////////////////////////////////////////////////////////////////
// RXgN^
DialogCustomize_File::DialogCustomize_File(DIALOGPROPERTY_CUSTOMIZE_FILE &rProperty)
	: DialogPropertyPage(GetResourceHandle(), MAKEINTRESOURCE(IDD), NULL),
	m_rProperty(rProperty)
{
}

// fXgN^
DialogCustomize_File::~DialogCustomize_File(void)
{
}


void DialogCustomize_File::AssociateDialogControls(void)
{
	m_cExclusion.SubclassDlgItem(IDC_CUSTOMIZE_FILE_EXCLUSION, this);
}

void DialogCustomize_File::UpdateData(const BOOL bUpdate /* = TRUE */)
{
	// _CAOIuWFNg
	if(bUpdate)
	{
		m_rProperty.nExclution = m_cExclusion.GetCurSel();
		m_rProperty.bCheckTimeStampOnActive = IsDlgButtonChecked(IDC_CUSTOMIZE_FILE_CHECKTIMESTAMPONACTIVE);
		m_rProperty.bOpenByThisFrame        = IsDlgButtonChecked(IDC_CUSTOMIZE_FILE_OPENBYTHISFRAME);
	}
	// IuWFNg_CAO
	else
	{
		m_cExclusion.SetCurSel(m_rProperty.nExclution);
		CheckDlgButton(IDC_CUSTOMIZE_FILE_CHECKTIMESTAMPONACTIVE, m_rProperty.bCheckTimeStampOnActive);
		CheckDlgButton(IDC_CUSTOMIZE_FILE_OPENBYTHISFRAME       , m_rProperty.bOpenByThisFrame);
	}
}


// _CAO
BOOL DialogCustomize_File::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	DialogPropertyPage::OnInitDialog(hWndFocus, dwInitParam);

	// e평
	InitToolTips();                         // c[`bv
	InitComboExclusive();                   // r[h̃R{{bNX

	UpdateData(FALSE);
	return FALSE;
}

// R}h
BOOL DialogCustomize_File::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	return DialogPropertyPage::OnCommand(wNotifyCode, wID, hWndCtrl);
}


////////////////////////////////////////////////////////////
// R}hnh


////////////////////////////////////////////////////////////
// 

// c[`bv
void DialogCustomize_File::InitToolTips(void)
{
	const UINT array[] =
	{
		IDC_CUSTOMIZE_FILE_EXCLUSION,
		IDC_CUSTOMIZE_FILE_CHECKTIMESTAMPONACTIVE,
		IDC_CUSTOMIZE_FILE_OPENBYTHISFRAME,
	};
	SetToolTips(array, countof(array));
}

// r[h̃R{{bNXݒ
void DialogCustomize_File::InitComboExclusive(void)
{
	const UINT uIDArray[] =
	{
		IDS_COMBO_CUSTOMIZE_EXCLUSION_NONE,
		IDS_COMBO_CUSTOMIZE_EXCLUSION_DISABLEWRITE,
		IDS_COMBO_CUSTOMIZE_EXCLUSION_DISABLEREADWRITE,
	};
	for(int i = 0; i < countof(uIDArray); i++)
	{
		wgc::tstring_t strAddData;
		wgc::wgfLoadString(m_hResource, uIDArray[i], strAddData);
		m_cExclusion.AddString(strAddData);
	}
}
