// NotifyBackup.cpp cCve[Vt@C
#include "NotifyBackup.h"


// RXgN^
DialogNotifyBackup::DialogNotifyBackup(HWND hWndParent, BACKUP_LIST_T &backup_list)
	: Dialog(GetResourceHandle(), MAKEINTRESOURCE(IDD), hWndParent), m_backup_list(backup_list)
{
	m_uOpenFileCount = 0;
}

// fXgN^
DialogNotifyBackup::~DialogNotifyBackup(void)
{
}

UINT DialogNotifyBackup::GetOpenFileCount(void) const
{
	return m_uOpenFileCount;
}


void DialogNotifyBackup::AssociateDialogControls(void)
{
	m_ctrlFileList.SubclassDlgItem(IDC_NOTIFYBACKUP_FILELIST, this);
}

void DialogNotifyBackup::UpdateData(const BOOL /* bUpdate = TRUE */)
{
}


// Xg{bNX̎w肳ꂽCfbNXɂt@CJ
void DialogNotifyBackup::Open(const UINT index)
{
	TCHAR szPathName[MAX_PATH];
	UINT  uCodePage;

	// {block}
	// t@CƃR[hy[W擾
	{
		m_ctrlFileList.GetText(index, szPathName);

		const DWORD_PTR dwItemData = m_ctrlFileList.GetItemData(index);
		uCodePage = static_cast<UINT>(dwItemData);
	}

	// {block}
	// łɂ̃t@CJĂt[΃ANeBuɂ
	{
		HWND hWnd = MainFrame::GetEditingFrame(szPathName);
		if(hWnd != NULL)
		{
			::SetForegroundWindow(hWnd);
			return;
		}
	}

	// {block}
	// JĂt[ΐVXbhŊJ
	{
		CREATEFRAME_PARAMETER *lpParameter = new CREATEFRAME_PARAMETER;
		::lstrcpyn(lpParameter->szPathName, szPathName, countof(lpParameter->szPathName));
		lpParameter->bReadOnly   = FALSE;
		lpParameter->nLineNumber = 0;
		lpParameter->nCmdShow    = SW_NORMAL;
		lpParameter->nCodePage   = uCodePage;

		Station::CreateFrameThread(lpParameter);

		m_uOpenFileCount++;
		return;
	}
}


// _CAO
BOOL DialogNotifyBackup::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	Dialog::OnInitDialog(hWndFocus, dwInitParam);

	// {block}
	// c[`bvݒ
	{
		const UINT array[] =
		{
			IDC_NOTIFYBACKUP_FILELIST,
		    IDC_NOTIFYBACKUP_OPEN,
		    IDC_NOTIFYBACKUP_OPEN_ALL,
		};
		SetToolTips(array, countof(array));
	}

	// {block}
	// t@CXg쐬
	{
		for(BACKUP_LIST_T::const_iterator p = m_backup_list.begin(); p != m_backup_list.end(); p++)
		{
			// t@CƃR[hy[W֘At
			const UINT uIndex = m_ctrlFileList.AddString(p->szFileName);
			m_ctrlFileList.SetItemData(uIndex, p->dwCodePage);
		}
	}

	OnCommand_FileList_SelChange();

	// t@CXgɃtH[JX킹
	SetDlgItemFocus(IDC_NOTIFYBACKUP_FILELIST);
	return FALSE;
}

BOOL DialogNotifyBackup::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	switch(wID)
	{
	case IDC_NOTIFYBACKUP_FILELIST:
		OnCommand_FileList(wNotifyCode);
		return FALSE;

	case IDC_NOTIFYBACKUP_OPEN:
		OnCommand_Open();
		return FALSE;

	case IDC_NOTIFYBACKUP_OPEN_ALL:
		OnCommand_OpenAll();
		return FALSE;
	}
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}

// t@CXgɃR}hꂽ
void DialogNotifyBackup::OnCommand_FileList(const WORD wNotifyCode)
{
	switch(wNotifyCode)
	{
	case LBN_SELCHANGE:
		OnCommand_FileList_SelChange();
		return;
	}
}

void DialogNotifyBackup::OnCommand_FileList_SelChange(void)
{
	HWND hWndCtrl = GetDlgItem(IDC_NOTIFYBACKUP_OPEN);
	const UINT uSelCount = m_ctrlFileList.GetSelCount();

	// Iڂ1ȏ゠΁uJv{^L
	::EnableWindow(hWndCtrl, uSelCount);
}

// It@CJ
void DialogNotifyBackup::OnCommand_Open(void)
{
	const UINT uItemCount = m_ctrlFileList.GetCount();
	for(UINT i = 0; i < uItemCount; i++)
	{
		// IĂACeJ
		if(m_ctrlFileList.GetSel(i))
		{
			Open(i);
		}
	}
}

// SẴt@CJă_CAO
void DialogNotifyBackup::OnCommand_OpenAll(void)
{
	const UINT uItemCount = m_ctrlFileList.GetCount();
	for(UINT i = 0; i < uItemCount; i++)
	{
		Open(i);
	}
	EndDialog(IDOK);
}
