// Station.cpp cCve[Vt@C
#include "Station.h"
#include "Setting.h"
#include "HtmlHelp_Utility.h"           // HtmlHelp_Execute()
#include "Dialog/NotifyBackup.h"


#define CLASSNAME_STATION   _T("MaxyStation")

// L̖O
#ifdef UNICODE
#define NAME_SHAREDMEMORY   _T("MaxySharedMemory (Unicode)")
#else
#define NAME_SHAREDMEMORY   _T("MaxySharedMemory")
#endif

// Maxy Station Message
#define MSM_POSTCOMMANDLINE         (WM_USER + 100)
#define MSM_NOTIFYEXITFRAMETHREAD   (WM_USER + 101)
#define MSM_HELPMESSAGE             (WM_USER + 102)

#define CMDLINE_LINE        _T("-L")
#define CMDLINE_CODEPAGE    _T("-C")
#define CMDLINE_READONLY    _T("-R")


LONG Station::m_lThreadCount = 0;
wgc::SharedMemory<SHARED_DATA> Station::m_cSharedMemory(NAME_SHAREDMEMORY);


// EChENX̓o^
void Station::Register(void)
{
	HINSTANCE hInstance = GetInstanceHandle();
	HICON   hIcon       = ::LoadIcon(GetResourceHandle(), MAKEINTRESOURCE(IDR_MAINFRAME));
	HCURSOR hCursor     = NULL;
	HBRUSH  hBrush      = NULL;

	WNDCLASS wndclass;
	wndclass.style         = 0;
	wndclass.lpfnWndProc   = _WindowProcBase;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInstance;
	wndclass.hIcon         = hIcon;
	wndclass.hCursor       = hCursor;
	wndclass.hbrBackground = hBrush;
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = CLASSNAME_STATION;
	if(RegisterClass(&wndclass) == 0)
	{
		wgc::wgfThrowLastError();
	}
}

Station *Station::CreateStation(const int nCmdShow, LPCTSTR lpCmdLine /* = NULL */)
{
	Station *pStation = new Station;

	// Xe[VEChE쐬
	const BOOL bResult = pStation->Create(
		CLASSNAME_STATION, _T(""),
		WS_OVERLAPPEDWINDOW | WS_MINIMIZE, 0,
		NULL);

	if(!bResult)
	{
		wgc::wgfThrowLastError();
	}

	// obNAbvt@C݂̑`FbN
	const UINT uOpenFileCount = pStation->CheckBackup();

	// R}hC
	pStation->ParseCommandLine(nCmdShow, lpCmdLine, (uOpenFileCount == 0));
	return pStation;
}

// 풓EChE
HWND Station::FindStation(void)
{
	return ::FindWindow(CLASSNAME_STATION, NULL);
}

void Station::PostCommandLine(HWND hWnd, LPCTSTR lpCmdLine)
{
	// LɃR}hCRs[
	LPSHARED_DATA lpSharedData = m_cSharedMemory.GetData(FILE_MAP_WRITE);
	{
		::lstrcpyn(lpSharedData->szCommandLine, lpCmdLine, countof(lpSharedData->szCommandLine));
	}
	m_cSharedMemory.ReleaseData(lpSharedData);
	lpSharedData = NULL;

	// EChEɃbZ[W𑗂
	::PostMessage(hWnd, MSM_POSTCOMMANDLINE, 0, 0);
}

void Station::CreateFrameThread(CREATEFRAME_PARAMETER *lpParameter /* = NULL */)
{
	// XbhIuWFNg쐬
	FrameThread::CreateThreadObject(lpParameter);

	::InterlockedIncrement(&m_lThreadCount);
}


// t[XbhIƂm点
void Station::NotifyExitFrameThread(FrameThread *pFrameThread)
{
	assert(pFrameThread != NULL);
	PostMessage(MSM_NOTIFYEXITFRAMETHREAD, 0, reinterpret_cast<LPARAM>(pFrameThread));
}

void Station::SendHelpMessage(const UINT uCommand /* = HH_DISPLAY_TOPIC */)
{
	SendMessage(MSM_HELPMESSAGE, uCommand);
}


////////////////////////////////////////////////////////////////////////////////
// proptected

Station::Station(void)
{
}


// obNAbvt@C݂̑`FbN
// JobNAbvt@C̐Ԃ
UINT Station::CheckBackup(void)
{
	BACKUP_LIST_T backup_list;

	// {block}
	// obNAbvt@C̃Xg쐬
	{
		DWORD dwIndex = 0;
		wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_BACKUP, TRUE);

		// obNAbvpZNV̒
		for(;;)
		{
			BACKUP backup;

			DWORD dwType;
			DWORD cbFileName = countof(backup.szFileName);
			DWORD cbData     = sizeof(backup.dwCodePage);

			const LONG lResult = reg.EnumerateValue(dwIndex++, backup.szFileName, cbFileName, dwType, reinterpret_cast<LPBYTE>(&backup.dwCodePage), cbData);

			// ERROR_SUCCESSłȂΏI
			if(lResult != ERROR_SUCCESS)
			{
				break;
			}

			// DWORD^łȂ΃XLbv
			if(dwType != REG_DWORD || cbData != sizeof(backup.dwCodePage))
			{
				continue;
			}

			backup_list.push_back(backup);
		}
	}

	// XgȂ0Ԃ
	if(backup_list.empty())
	{
		return 0;
	}

	// mF_CAOJ
	DialogNotifyBackup dlg(m_hWnd, backup_list);
	dlg.DoModal();

	// {block}
	// WXgɕۑꂽt@CNA
	{
		wgc::Registry reg(HKEY_CURRENT_USER, REGKEY_SECTION_BACKUP, TRUE);
		for(BACKUP_LIST_T::const_iterator p = backup_list.begin(); p != backup_list.end(); p++)
		{
			reg.DeleteValue(p->szFileName);
		}
	}

	return dlg.GetOpenFileCount();
}


////////////////////////////////////////////////////////////
// EChEvV[W
LRESULT Station::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case MSM_POSTCOMMANDLINE:
		OnPostCommandLine();
		return 0;

	case MSM_NOTIFYEXITFRAMETHREAD:
		OnNotifyExitFrameThread(reinterpret_cast<FrameThread *>(lParam));
		return 0;

	case MSM_HELPMESSAGE:
		OnHelpMessage(static_cast<UINT>(wParam));
		return 0;
	}
	return Window::WindowProc(uMsg, wParam, lParam);
}


////////////////////////////////////////////////////////////
// bZ[Wnh

void Station::OnClose(void)
{
	DestroyWindow();
}

void Station::OnDestroy(void)
{
	::PostQuitMessage(0);
}

// R}hCbZ[W|Xgꂽ
void Station::OnPostCommandLine(void)
{
	// Lf[^擾
	LPSHARED_DATA lpSharedData = m_cSharedMemory.GetData();
	{
		// |XgꂽR}hC
		ParseCommandLine(SW_NORMAL, lpSharedData->szCommandLine);
	}
	m_cSharedMemory.ReleaseData(lpSharedData);
	lpSharedData = NULL;
}

// t[XbhI̒ʒm
void Station::OnNotifyExitFrameThread(FrameThread *pFrameThread)
{
	// {block}
	// XbhIuWFNg폜
	{
		pFrameThread->Wait();

		FrameThread::DeleteThreadObject(pFrameThread);
		pFrameThread = NULL;
	}

	// t[XbhׂďIXe[VI
	if(::InterlockedDecrement(&m_lThreadCount) == 0)
	{
		SendMessage(WM_CLOSE, 0, 0);
	}
}

void Station::OnHelpMessage(const UINT uCommand)
{
	HH_FTS_QUERY query = {sizeof(query)};

	// HTMLwvĂяo
	HtmlHelp_Execute(
		NULL,
		uCommand,
		reinterpret_cast<DWORD_PTR>(&query));
}


////////////////////////////////////////////////////////////
// R}hC̉

void Station::ParseCommandLine(const int nCmdShow, LPCTSTR lpCmdLine, const BOOL bNeedNewFrame /* = TRUE */)
{
	typedef struct tagCOMMANDLINE_INFO
	{
		LPCTSTR lpszOption;
		LPCTSTR lpszFormat;
		void   *lpData;
	} COMMANDLINE_INFO;

	if(lpCmdLine == NULL)
	{
		lpCmdLine = _T("");
	}

	// VKt[K{łȂAR}hCȂ牽Ȃ
	if(!bNeedNewFrame && lpCmdLine[0] == _T('\0'))
	{
		return;
	}

	do
	{
		// ftHglݒ
		CREATEFRAME_PARAMETER *lpParameter = new CREATEFRAME_PARAMETER;
		lpParameter->szPathName[0] = wgc::tNUL;
		lpParameter->bReadOnly     = FALSE;
		lpParameter->nLineNumber   = 1;
		lpParameter->nCodePage     = CODEPAGE_ERROR;
		lpParameter->nCmdShow      = nCmdShow;

		const COMMANDLINE_INFO cinfo_array[] =
		{
			{CMDLINE_LINE    , _T("%d"), &lpParameter->nLineNumber},
			{CMDLINE_CODEPAGE, _T("%d"), &lpParameter->nCodePage  },
			{CMDLINE_READONLY,     NULL, &lpParameter->bReadOnly  },
		};

		while(*lpCmdLine != wgc::tNUL)
		{
			// o
			ARGUMENT_INFO ainfo;
			const BOOL bQuote = ExtractArgument(lpCmdLine, ainfo);

			// o𕶎ɂ
			wgc::tstring_t command(&lpCmdLine[ainfo.begin], ainfo.length);
			lpCmdLine += ainfo.next;

			// pň͂ĂȂ΃IvV`FbN
			// ipň͂Ă΃t@CƂ݂Ȃj
			if(!bQuote)
			{
				for(int i = 0; i < countof(cinfo_array); i++)
				{
					// oƃIvVr
					const COMMANDLINE_INFO &cinfo = cinfo_array[i];
					if(command.find(cinfo.lpszOption) == 0)
					{
						// 㑱ϊ
						// ϊ΁Aɏ]ĕϊ
						if(cinfo.lpszFormat != NULL)
						{
							const int nLength = ::lstrlen(cinfo.lpszOption);
							const int nResult = _stscanf(
								command.c_str() + nLength,
								cinfo.lpszFormat,
								cinfo.lpData);

							if(nResult == 1)
							{
								goto next;
							}
						}
						// ϊȂ΁AlpDataBOOL^Ƃ݂ȂătO𗧂Ă
						else
						{
							LPBOOL lpBoolData = reinterpret_cast<LPBOOL>(cinfo.lpData);
							*lpBoolData = TRUE;
							goto next;
						}
					}
				}
			}
			// IvVYȂ΃t@CƂ݂Ȃ
			::lstrcpyn(lpParameter->szPathName, command.c_str(), countof(lpParameter->szPathName));
			break;
next:;
		}

		// VKXbh쐬
		// imۂ ThreadMain() ō폜j
		CreateFrameThread(lpParameter);
	}
	while(*lpCmdLine != wgc::tNUL);
}

// R}hCo
BOOL Station::ExtractArgument(LPCTSTR lpCmdLine, ARGUMENT_INFO &rInfo)
{
	BOOL bQuote = FALSE;
	int  pos = 0;

	// 擪̋󔒂
	while(lpCmdLine[pos] == wgc::tSPACE) { pos++; }

	// p`FbN
	if(lpCmdLine[pos] == wgc::tDQUOTE)
	{
		bQuote = TRUE;
		pos++;
	}

	rInfo.begin = pos;

	// I[`FbN
	// pĂꍇ
	if(bQuote)
	{
		BOOL bEndQuote = FALSE;

		// ΉpT
		while(lpCmdLine[pos] != wgc::tNUL)
		{
			if(lpCmdLine[pos] == wgc::tDQUOTE)
			{
				bEndQuote = TRUE;
				break;
			}
			pos++;
		}
		rInfo.length = pos - rInfo.begin;
		if(bEndQuote) { pos++; }
	}
	// pĂȂꍇ
	else
	{
		BOOL bEndSpace = FALSE;

		// 󔒂T
		while(lpCmdLine[pos] != wgc::tNUL)
		{
			if(lpCmdLine[pos] == wgc::tSPACE)
			{
				bEndSpace = TRUE;
				break;
			}
			pos++;
		}
		rInfo.length = pos - rInfo.begin;
		if(bEndSpace) { pos++; }
	}

	// ̋󔒂
	while(lpCmdLine[pos] == wgc::tSPACE) { pos++; }

	rInfo.next = pos;
	return bQuote;
}
