// ThreadBase.h c Xbh̊{NX
#ifndef __THREAD_BASE__
#define __THREAD_BASE__

#include "sgc.h"
#include <stddef.h>                     // NULL


_SGC_BEGIN

// XbhNX
class ThreadBase
{
public:
	// Xbh̏
	typedef enum _beginmode_t
	{
		BEGINMODE_NORMAL,                       // ʏ
		BEGINMODE_SUSPEND,                      // TXyh
	} beginmode_t;

	// RXgN^/fXgN^
	ThreadBase(void *param = NULL, const beginmode_t beginmode = BEGINMODE_NORMAL);
	virtual ~ThreadBase(void);

	// f/ĊJ
	int suspend(void);
	int resume (void);

	// ҋ@
	enum { WAIT_INFINITE = 0xffffffff };
	void wait(const unsigned long milliseconds = WAIT_INFINITE);

protected:
	// Xbh̃C֐
	virtual unsigned _ThreadMain(void *param) = 0;

	// I
	void _Exit(const unsigned endcode = 0);

private:
	// Xbh
	unsigned long m_dwThread;               // Xbhnh
	unsigned      m_uThreadID;              // XbhID

	typedef struct _this_param_t
	{
		ThreadBase *this_ptr;
		void   *param;
	} this_param_t;

	static unsigned __stdcall _ThreadProc(void *this_param_ptr);
};

_SGC_END

#endif // __THREAD_BASE__
