// DialogTree.cpp cCve[Vt@C
#include "DialogTree.h"
#include "../wgfunc.h"                  // wgfLoadString()

#include <map>


_WXC_BEGIN                              // namespace wxc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogTree::DialogTree(
	const UINT uIDTree, const UINT uIDGroup,
	const CATEGORY arCategory[], const UINT uCategoryCount,
	HINSTANCE hResource, LPCTSTR lpTemplate, HWND hWndParent /* = NULL */)

	: Dialog(hResource, lpTemplate, hWndParent),
	  m_uIDTree(uIDTree), m_uIDGroup(uIDGroup),
	  m_pCategory(arCategory), m_uCategoryCount(uCategoryCount)
{
}

// fXgN^
DialogTree::~DialogTree(void)
{
}


////////////////////////////////////////////////////////////////////////////////
// bZ[Wnh

BOOL DialogTree::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	Dialog::OnInitDialog(hWndFocus, dwInitParam);

	m_treeCategory.SubclassDlgItem(m_uIDTree, this);

	// ID-c[ACeΉ}bv
	std::map<UINT, HTREEITEM> tree_map;
	tree_map[0] = TVI_ROOT;

	// c[r[Rg[ɃJeSǉ
	for(UINT i = 0; i < m_uCategoryCount; i++)
	{
		// JeS̕擾
		wgc::tstring_t category;
		wgc::wgfLoadString(m_hResource, m_pCategory[i].uID, category);

		// }JeS̕Kvf[^낦
		TVINSERTSTRUCT insertstruct;
		insertstruct.hInsertAfter	 = TVI_LAST;
		insertstruct.hParent         = tree_map[m_pCategory[i].uIDParent];
		insertstruct.item.mask       = TVIF_PARAM | TVIF_TEXT;
		insertstruct.item.lParam     = i;
		insertstruct.item.pszText    = const_cast <LPTSTR>(category.c_str ());
		insertstruct.item.cchTextMax = static_cast<int   >(category.length());

		// JeSǉAeACeWJ
		HTREEITEM hItem = m_treeCategory.InsertItem(insertstruct);
		m_treeCategory.Expand(insertstruct.hParent, TVE_EXPAND);

		tree_map[m_pCategory[i].uID] = hItem;

		// Rg[B
		ShowCategoryControls(i, FALSE);
	}

	// {block}
	// ŏ̃ACeI
	{
		const UINT uIDCategory = m_pCategory[0].uID;
		m_treeCategory.SelectItem(tree_map[uIDCategory]);
	}

	return TRUE;
}

BOOL DialogTree::OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader)
{
	if(nIdCtrl == static_cast<int>(m_uIDTree) && lpNmHeader->code == TVN_SELCHANGED)
	{
		return OnSelchangedTreeCategory(lpNmHeader);
	}
	return Dialog::OnNotify(nIdCtrl, lpNmHeader);
}


////////////////////////////////////////////////////////////////////////////////
// private ֐

// JeS̃Rg[̕\/\
void DialogTree::ShowCategoryControls(const LONG_PTR nCategoryIndex, const BOOL bShow /* = TRUE */)
{
	// O[v{bNXɃLvV\
	if(bShow)
	{
		wgc::tstring_t caption;
		wgc::wgfLoadString(m_hResource, m_pCategory[nCategoryIndex].uID, caption);

		wgc::Window group(GetDlgItem(m_uIDGroup));
		group.SetWindowText(caption);
	}

	// {block}
	// w肳ꂽJeS̃Rg[̏ԂύX
	{
		const int nCmdShow = bShow ? SW_SHOW : SW_HIDE;
		for(int i = 0; i < DIALOG_TREE_MAX_CONTROLS; i++)
		{
			// Rg[ID擾
			const UINT uID = m_pCategory[nCategoryIndex].uIDControlArray[i];
			if(uID == 0)
			{
				// ID0ȂI
				break;
			}

			// Rg[\
			wgc::Window ctrl(GetDlgItem(uID));
			ctrl.ShowWindow(nCmdShow);
		}
	}
}


BOOL DialogTree::OnSelchangedTreeCategory(NMHDR* pNMHDR) 
{
	LPNM_TREEVIEW lpNMTreeView = reinterpret_cast<LPNM_TREEVIEW>(pNMHDR);

	const LONG_PTR nOldIndex = lpNMTreeView->itemOld.lParam;
	const LONG_PTR nNewIndex = lpNMTreeView->itemNew.lParam;

	ShowCategoryControls(nOldIndex, FALSE);
	ShowCategoryControls(nNewIndex, TRUE);

	return FALSE;
}

_WXC_END                                // }
