// thread_base.cpp
#include "thread_base.h"
#include <windows.h>                    // ::xxxThread(), ::WaitForSingleObject(), ::CloseHandle()
#include <process.h>                    // _beginthreadex(), _endthreadex()
#include <assert.h>                     // assert()


#ifdef  _MT

_SGC_BEGIN                              // namespace sgc {

////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
thread_base::thread_base(
	void *param /* = NULL */,
	const thread_base::beginmode_t beginmode /* = BEGINMODE_NORMAL */)
{
	this_param_t *this_param_ptr = new this_param_t;
	this_param_ptr->this_ptr = this;
	this_param_ptr->param    = param;

	// Xbh̏Ԃ
	DWORD dwCreationFlags = 0;
	switch(beginmode)
	{
	case BEGINMODE_SUSPEND:
		dwCreationFlags = CREATE_SUSPENDED;
		break;
	}

	// Xbh쐬
	m_dwThread = _beginthreadex(
		NULL, 0,
		_ThreadProc, this_param_ptr,
		dwCreationFlags,
		&m_uThreadID);

	// Xbh̍쐬Ɏsꍇ
	if(m_dwThread == 0)
	{
		// ꍇ́Athread_base::_ThreadProc() ̒ delete 
		delete this_param_ptr;
	}
}

// fXgN^
thread_base::~thread_base(void)
{
	// nhJ
	HANDLE hThread = reinterpret_cast<HANDLE>(m_dwThread);
	::CloseHandle(hThread);
}


////////////////////////////////////////////////////////////
// Iy[V

// f
int thread_base::suspend(void)
{
	HANDLE hThread  = reinterpret_cast<HANDLE>(m_dwThread);
	DWORD  dwResult = ::SuspendThread(hThread);
	return static_cast<int>(dwResult);
}

// ĊJ
int thread_base::resume(void)
{
	HANDLE hThread  = reinterpret_cast<HANDLE>(m_dwThread);
	DWORD  dwResult = ::ResumeThread(hThread);
	return static_cast<int>(dwResult);
}

// ҋ@
void thread_base::wait(const unsigned long milliseconds /* = WAIT_INFINITE */)
{
	HANDLE hThread  = reinterpret_cast<HANDLE>(m_dwThread);
	::WaitForSingleObject(hThread, milliseconds);
}


////////////////////////////////////////////////////////////
// protected ֐

// I
void thread_base::_Exit(const unsigned endcode /* = 0 */)
{
	_endthreadex(endcode);
}


////////////////////////////////////////////////////////////
// private ֐

// XbhvV[W
unsigned __stdcall thread_base::_ThreadProc(void *this_param_ptr)
{
	assert(this_param_ptr != NULL);

	// this |C^ƃp[^擾
	this_param_t *ptr = reinterpret_cast<this_param_t *>(this_param_ptr);
	thread_base *this_ptr = ptr->this_ptr;
	void   *param    = ptr->param;
	delete ptr;

	// XbhJn
	return this_ptr->_ThreadMain(param);
}

_SGC_END                                // }



////////////////////////////////////////////////////////////////////////////////
// P̃eXgpR[h
#ifdef __UNITTEST_THREAD__

#include <iostream>


// hNX쐬
class test_thread : public sgc::thread_base
{
public:
	test_thread(const int num, beginmode_t mode = BEGINMODE_NORMAL)
		: thread_base(reinterpret_cast<void *>(num), mode)
	{
		m_num = num;
		std::cout << "Thread(" << m_num << ") begin" << std::endl;
	}

	~test_thread(void)
	{
		std::cout << "Thread(" << m_num << ") end" << std::endl;
	}

protected:
	// Xbh̃C֐
	unsigned _ThreadMain(void *param)
	{
		const int thread_num = reinterpret_cast<int>(param);

		// JEg
		for(int i = 0; i < 100; i++)
		{
			std::cout << "Thread(" << thread_num << ") : " << i << std::endl;
		}

		return 0;
	}

private:
	int m_num;
};


// main֐
int main(void)
{
	int test_no = 1;

	// Ƃ肠ʂɎs
	{
		std::cout << "============================================================" << std::endl;
		std::cout << "eXg" << test_no++ << "iƂ肠ʂɎsj" << std::endl;

		// Xbh쐬
		test_thread newthread1(1);

		// JEg
		for(int i = 0; i < 100; i++)
		{
			std::cout << "Main : " << i << std::endl;
		}

		// I҂
		newthread1.wait();
	}

	// Xbh2쐬
	{
		std::cout << "============================================================" << std::endl;
		std::cout << "eXg" << test_no++ << "iXbh2쐬j" << std::endl;

		test_thread newthread1(1);
		test_thread newthread2(2);

		for(int i = 0; i < 100; i++)
		{
			std::cout << "Main : " << i << std::endl;
		}

		newthread1.wait();
		newthread2.wait();
	}

	// wait() ȂĂI邩H
	{
		std::cout << "============================================================" << std::endl;
		std::cout << "eXg" << test_no++ << "iwait() ȂĂI邩Hj" << std::endl;

		test_thread newthread1(1);

		for(int i = 0; i < 100; i++)
		{
			std::cout << "Main : " << i << std::endl;
		}

//		newthread1.wait();
	}

	// XbhTXyhԂ̂ƂłI邩H
	{
		std::cout << "============================================================" << std::endl;
		std::cout << "eXg" << test_no++ << "iXbhTXyhԂ̂ƂłI邩Hj" << std::endl;

		// TXyh[hŋN
		test_thread newthread1(1, sgc::thread_base::BEGINMODE_SUSPEND);

		for(int i = 0; i < 100; i++)
		{
			std::cout << "Main : " << i << std::endl;
		}
	}

	// thread_base::suspend() / thread_base::resume() ̃eXg
	{
		std::cout << "============================================================" << std::endl;
		std::cout << "eXg" << test_no++ << "ithread_base::suspend() / thread_base::resume() ̃eXgj" << std::endl;

		test_thread newthread1(1);

		newthread1.suspend();
		{
			// ̊ԁAXbh̏o͂͂Ȃ͂
			for(int i = 0; i < 100; i++)
			{
				std::cout << "Main : " << i << std::endl;
			}
		}
		newthread1.resume();
		newthread1.wait();
	}

	return 0;
}

#endif // __UNITTEST_THREAD__

#endif // _MT
