// OpenSave.cpp cCve[Vt@C
#include "OpenSave.h"


// anonymous namespace
namespace
{
	wgc::tstring_t CreateDialogFilter(const BOOL bAddAllFiles = TRUE);
}


////////////////////////////////////////////////////////////////////////////////
// DialogOpen

// RXgN^
DialogOpen::DialogOpen(HWND hWndParent /* = NULL */)
	: wgc::DialogCommon_OpenSave(GetResourceHandle(), hWndParent, NULL, TRUE, OFN_ALLOWMULTISELECT | OFN_LONGNAMES | OFN_EXPLORER | OFN_FILEMUSTEXIST)
{
	m_ofn.nFilterIndex = static_cast<DWORD>(GetEditViewPropertySize());

	// tB^
	m_strFilter = CreateDialogFilter();
	m_ofn.lpstrFilter = m_strFilter.c_str();
}

// fXgN^
DialogOpen::~DialogOpen(void)
{
}

void DialogOpen::AssociateDialogControls(void)
{
}

void DialogOpen::UpdateData(const BOOL /* bUpdate = TRUE */)
{
}


////////////////////////////////////////////////////////////////////////////////
// DialogSave

// RXgN^
DialogSave::DialogSave(HWND hWndParent /* = NULL */)
	: wgc::DialogCommon_OpenSave(GetResourceHandle(), hWndParent, NULL, TRUE, OFN_LONGNAMES | OFN_EXPLORER)
{
	m_ofn.nFilterIndex = static_cast<DWORD>(GetEditViewPropertySize());

	// tB^
	m_strFilter = CreateDialogFilter();
	m_ofn.lpstrFilter = m_strFilter.c_str();
}

// fXgN^
DialogSave::~DialogSave(void)
{
}

void DialogSave::AssociateDialogControls(void)
{
}

void DialogSave::UpdateData(const BOOL /* bUpdate = TRUE */)
{
}


////////////////////////////////////////////////////////////////////////////////
// anonymous namespace
namespace
{

wgc::tstring_t CreateDialogFilter(const BOOL bAddAllFiles /* = TRUE */)
{
	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();

	// tB^쐬
	wgc::tstring_t strFilter;
	for(size_t i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		strFilter += prView.szSettingName;
		strFilter += wgc::tNUL;
		strFilter += prView.szFilter;
		strFilter += wgc::tNUL;
	}

	// uׂẴt@CvŌɒǉ
	if(bAddAllFiles)
	{
		wgc::tstring_t strAllFiles;
		AppLoadString(IDS_FILTER_ALLFILES, strAllFiles);

		strFilter += strAllFiles;
		strFilter += wgc::tNUL;
		strFilter += STR_FILTER_ALL;
		strFilter += wgc::tNUL;
	}
	return strFilter;
}

}
