// FrameThread.cpp cCve[Vt@C
#include "FrameThread.h"
#include "Setting.h"
#include "WinMain.h"
#include "HtmlHelp_Utility.h"


////////////////////////////////////////////////////////////////////////////////
// RXgNV

// XbhIuWFNg쐬
FrameThread *FrameThread::CreateThreadObject(CREATEFRAME_PARAMETER *lpParameter)
{
	FrameThread *pFrameThread = new FrameThread;
	pFrameThread->Run(lpParameter);

	return pFrameThread;
}

// XbhIuWFNgj
void FrameThread::DeleteThreadObject(FrameThread *pFrameThread)
{
	delete pFrameThread;
}

// RXgN^
FrameThread::FrameThread(void) : m_pMainFrame(NULL)
{
}

// fXgN^
FrameThread::~FrameThread(void)
{
}


////////////////////////////////////////////////////////////////////////////////
// ThreadMain

DWORD FrameThread::ThreadMain(LPVOID lpParameter)
{
	// ThreadMain() ̖߂l
	WPARAM wParam = 0;

	CREATEFRAME_PARAMETER *lpCreateFrameParameter = reinterpret_cast<CREATEFRAME_PARAMETER *>(lpParameter);
	if(!InitInstance(lpCreateFrameParameter))
	{
		goto error;
	}

	// bZ[W[v
	for(;;)
	{
		MSG msg;

		// L[̃bZ[W擾
		const BOOL bResult = ::GetMessage(&msg, NULL, 0, 0);
		if(bResult == 0 || bResult == -1)
		{
			// WM_QUIT or APIG[
			wParam = msg.wParam;
			break;
		}

		// bZ[W
		HandleMessage(msg);
	}

	// ɐǏ㏈Lq

error:
	// 狤ʂ̌㏈
	ExitInstance();
	Station_NotifyExitFrameThread(this);
	return static_cast<DWORD>(wParam);
}

// bZ[W
BOOL FrameThread::HandleMessage(MSG &rMsg)
{
	try
	{
		// R}hUIXV
		m_pMainFrame->PreHandleMessage();

		// ::TranslateAccelerator() ɓn
		if(m_pMainFrame->TranslateAccelerator(GetAcceleratorHandle(), &rMsg))
		{
			return TRUE;
		}

		// ŏĂȂ΂ŏ
		::TranslateMessage(&rMsg);
		::DispatchMessage (&rMsg);
		return FALSE;
	}
	catch(const HRESULT hResult)
	{
		// EChEvV[W̗OLb`
		m_pMainFrame->ErrorMessageBox(hResult);
		return FALSE;
	}
}

// Ct[쐬
void FrameThread::CreateMainFrame(CREATEFRAME_PARAMETER *lpCreateFrameParameter)
{
	// Xbhɓnꂽp[^Ńt[쐬
	if(lpCreateFrameParameter == NULL)
	{
		lpCreateFrameParameter = new CREATEFRAME_PARAMETER;
		lpCreateFrameParameter->szPathName[0] = wgc::tNUL;
		lpCreateFrameParameter->bReadOnly     = FALSE;
		lpCreateFrameParameter->nLineNumber   = 1;
		lpCreateFrameParameter->nCodePage     = CP_ACP;
		lpCreateFrameParameter->nCmdShow      = SW_NORMAL;
	}

	// {block}
	// Ct[쐬
	{
		MAINFRAME_PROPERTY property;
		GetMainFrameProperty(property);

		WINDOWPLACEMENT wndpl;
		GetWindowPlacementParameter(wndpl);

		LPWINDOWPLACEMENT lpWndPl = NULL;
		if(property.stDisplay.flags.elements.bRestorePlacement)
		{
			lpWndPl = &wndpl;
		}

		m_pMainFrame = MainFrame::CreateFrame(lpCreateFrameParameter, lpWndPl);
		assert(m_pMainFrame != NULL);
	}

	delete lpCreateFrameParameter;
	lpCreateFrameParameter = NULL;
}

void FrameThread::DestroyMainFrame(void)
{
	// ̎_łłɃEChE͔jĂ
	MainFrame::DeleteFrame(m_pMainFrame);
	m_pMainFrame = NULL;
}


BOOL FrameThread::InitInstance(CREATEFRAME_PARAMETER *lpCreateFrameParameter)
{
	try
	{
		::OleInitialize(NULL);
		CreateMainFrame(lpCreateFrameParameter);
		return TRUE;
	}
	catch(const HRESULT hResult)
	{
		AppErrorMessageBox(NULL, hResult);
		return FALSE;
	}
}

BOOL FrameThread::ExitInstance(void)
{
	DestroyMainFrame();                     // CEChEj
	::OleUninitialize();
	return TRUE;
}
