// DialogCommon_OpenSave.cpp cCve[Vt@C
#include "DialogCommon_OpenSave.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogCommon_OpenSave::DialogCommon_OpenSave(HINSTANCE hResource, HWND hWndParent /* = NULL */, LPCTSTR lpTemplate /* = NULL */, const BOOL bOpen /* = TRUE */, const DWORD dwFlags /* = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY */, const DWORD dwBufferSize /* = 65535 */)
	: DialogCommon(hResource, hWndParent, lpTemplate), m_bOpen(bOpen), m_nFileOffset(-1)
{
	m_buffer.resize(dwBufferSize);

	::ZeroMemory(&m_ofn, sizeof(m_ofn));
	m_ofn.lStructSize    = sizeof(m_ofn);
	m_ofn.hwndOwner      = hWndParent;
	m_ofn.Flags          = dwFlags;

	m_ofn.lpstrTitle     = NULL;

	m_ofn.lpstrFile      = &m_buffer[0];
	m_ofn.nMaxFile       = dwBufferSize;

/*
	// tbNvV[Wo^
	{
		m_ofn.Flags   |= OFN_ENABLEHOOK;
		m_ofn.lpfnHook = reinterpret_cast<LPOFNHOOKPROC>(Window::_WindowProcBase);
	}
// */

	// _CAOev[go^
	if(lpTemplate != NULL)
	{
		m_ofn.Flags         |= OFN_ENABLETEMPLATE;
		m_ofn.lpTemplateName = lpTemplate;
	}
}

// fXgN^
DialogCommon_OpenSave::~DialogCommon_OpenSave(void)
{
}


BOOL DialogCommon_OpenSave::IsReadOnly(void) const
{
	return m_ofn.Flags & OFN_READONLY;
}

DWORD DialogCommon_OpenSave::GetFilterIndex(void) const
{
	return m_ofn.nFilterIndex;
}

BOOL DialogCommon_OpenSave::GetNextPathName(LPTSTR lpszBuffer, const SIZE_T nSizeBuffer)
{
	// DoModal()ĂяoĂȂorG[̏ꍇ
	if(m_nFileOffset < 0)
	{
		return FALSE;
	}

	if(m_nFileOffset >= static_cast<int>(m_buffer.size()) || m_buffer[m_nFileOffset] == tNUL)
	{
		return FALSE;
	}

	const int nSizeBufferInt = static_cast<int>(nSizeBuffer);

	// t@C1IȂꍇ
	if(m_nFileOffset == 0)
	{
		::lstrcpyn(lpszBuffer, &m_buffer[0], nSizeBufferInt);
		m_nFileOffset = -1;
		return TRUE;
	}

	// t@CIꂽꍇ
	// t@C擾ApXƘA
	wgc::tstring_t strFileName = &m_buffer[m_nFileOffset];
	wgc::tstring_t strPathName = m_strDirName + _T('\\') + strFileName;

	::lstrcpyn(lpszBuffer, strPathName.c_str(), nSizeBufferInt);

	m_nFileOffset += static_cast<int>(strFileName.length() + 1);
	return TRUE;
}


// _CAO\
BOOL DialogCommon_OpenSave::CreateCommonDialog_Modal(const LPARAM dwInitParam, INT_PTR &iResult)
{
	m_ofn.lCustData = dwInitParam;

	BOOL bResult = 0;
	if(m_bOpen) { bResult = ::GetOpenFileName(&m_ofn); }
	else        { bResult = ::GetSaveFileName(&m_ofn); }

	iResult = bResult;

	if(bResult)
	{
		m_nFileOffset = 0;
		if(m_ofn.nFileOffset > 0 && m_buffer[m_ofn.nFileOffset - 1] == tNUL)
		{
			m_strDirName  = &m_buffer[0];
			m_nFileOffset = m_ofn.nFileOffset;
		}
		UpdateData();
	}
	else
	{
		const DWORD dwExtendedError = ::CommDlgExtendedError();
		if(dwExtendedError != 0)
		{
			return FALSE;
		}
	}
	return TRUE;
}

BOOL DialogCommon_OpenSave::CreateCommonDialog_Modeless(const LPARAM /* dwInitParam */, INT_PTR & /* iResult */)
{
	// [hX_CAO͍Ȃ
	return FALSE;
}

_WGC_END                                // }
